/*
 * Decompiled with CFR 0.152.
 */
package valueTypes;

import parser.ExpressionNode;
import parser.Value;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ErrorValue;
import valueTypes.NullValue;

public class FunctionValue
extends Value {
    ExpressionNode[] statements;

    public FunctionValue(ExpressionNode function) {
        if (function instanceof CharacterSeparatedStatementPair) {
            CharacterSeparatedStatementPair pair = (CharacterSeparatedStatementPair)function;
            if (pair.getSymbol().equals(";")) {
                this.statements = pair.extractAllStatements();
            } else {
                this.statements = new ExpressionNode[1];
                this.statements[0] = new ErrorValue("only statements which are separated by semicolons ';' are allowed as statements within functions. '" + pair.getSymbol() + "' is an invalid statement separator.");
            }
        } else {
            this.statements = new ExpressionNode[1];
            this.statements[0] = function;
        }
    }

    public String getType() {
        return "function";
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("{");
        int i = 0;
        while (i < this.statements.length) {
            b.append(String.valueOf(this.statements[i].toString()) + (i < this.statements.length - 1 ? "; " : ""));
            ++i;
        }
        b.append("}");
        return b.toString();
    }

    public boolean equals(Object o) {
        return o instanceof FunctionValue ? this.toString().equals(((FunctionValue)o).toString()) : false;
    }

    public Value executeFunction() {
        int i = 0;
        while (i < this.statements.length) {
            Value v = this.statements[i].evaluate();
            if (v instanceof ErrorValue) {
                return v;
            }
            ++i;
        }
        return NullValue.NULL;
    }
}

