/*
 * Decompiled with CFR 0.152.
 */
package valueTypes;

import java.util.ArrayList;
import operators.BinaryOperator;
import parser.ExpressionNode;
import parser.Value;
import valueTypes.ErrorValue;

public class CharacterSeparatedStatementPair
extends BinaryOperator {
    public CharacterSeparatedStatementPair(String symbol, ExpressionNode leftChild, ExpressionNode rightChild) {
        super(symbol, leftChild, rightChild);
    }

    public ExpressionNode getLeftStatement() {
        return this.leftChild;
    }

    public ExpressionNode getRightStatement() {
        return this.rightChild;
    }

    public ExpressionNode[] extractAllStatements() {
        ExpressionNode[] statements;
        ArrayList extractedStatements = new ArrayList();
        if (this.extractAllStatements(extractedStatements, this)) {
            statements = new ExpressionNode[extractedStatements.size()];
            int i = 0;
            while (i < statements.length) {
                statements[i] = (ExpressionNode)extractedStatements.get(i);
                ++i;
            }
        } else {
            statements = new ExpressionNode[]{new ErrorValue("inconsistant characters used as statement sepatarors.")};
        }
        return statements;
    }

    private boolean extractAllStatements(ArrayList statements, CharacterSeparatedStatementPair pair) {
        boolean success = true;
        ExpressionNode leftStatement = pair.getLeftStatement();
        if (leftStatement instanceof CharacterSeparatedStatementPair) {
            CharacterSeparatedStatementPair leftPair = (CharacterSeparatedStatementPair)leftStatement;
            if (leftPair.getSymbol().equals(pair.getSymbol())) {
                success = this.extractAllStatements(statements, leftPair);
            } else {
                success = false;
                statements.add(leftStatement);
            }
        } else {
            statements.add(leftStatement);
        }
        statements.add(pair.getRightStatement());
        return success;
    }

    public Value evaluate() {
        return new ErrorValue("statements separated by the '" + this.symbol + "' character should not be evaluated. They should only be used as a part of some construct (such as a function definition or when defining a \"for\" loop");
    }
}

