/*
 * Decompiled with CFR 0.152.
 */
package operators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import operators.BinaryOperator;
import operators.BinaryOperatorCreator;
import operators.ForLoop;
import operators.Minus;
import operators.RealNumberBinaryOperator;
import operators.RealNumberUnaryOperator;
import operators.UnaryOperator;
import operators.UnaryOperatorCreator;
import parser.ExpressionNode;
import parser.RecursiveDescentParser;
import parser.Value;
import valueTypes.BooleanValue;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ErrorValue;
import valueTypes.FunctionValue;
import valueTypes.NullValue;
import variables.Variable;

public class Operators {
    private static Map binaryOperators = null;
    private static Map unaryOperators = null;

    public static void getBinaryOperators(RecursiveDescentParser parent) {
        Operators.createAllBinaryOperators();
        Iterator it = binaryOperators.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            parent.addBinaryOperator((String)entry.getKey(), (BinaryOperatorCreator)entry.getValue());
        }
    }

    private static void createAllBinaryOperators() {
        if (binaryOperators == null) {
            binaryOperators = new HashMap();
            binaryOperators.put("+", new BinaryOperatorCreator(1){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator(this, '+', left, right){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double l, double r) {
                            return l + r;
                        }
                    };
                }
            });
            binaryOperators.put("-", new Minus());
            binaryOperators.put("*", new BinaryOperatorCreator(2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator(this, '*', left, right){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double l, double r) {
                            return l * r;
                        }
                    };
                }
            });
            binaryOperators.put("/", new BinaryOperatorCreator(2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator(this, '/', left, right){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double l, double r) {
                            return l / r;
                        }
                    };
                }
            });
            binaryOperators.put("%", new BinaryOperatorCreator(2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator(this, '%', left, right){
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double l, double r) {
                            return l % r;
                        }
                    };
                }
            });
            binaryOperators.put("^", new BinaryOperatorCreator(3){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator(this, '^', left, right){
                        final /* synthetic */ 9 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double l, double r) {
                            return Math.pow(l, r);
                        }
                    };
                }
            });
            binaryOperators.put("E", new BinaryOperatorCreator(4){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator(this, 'E', left, right){
                        final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double l, double r) {
                            return l * Math.pow(10.0, r);
                        }
                    };
                }
            });
            binaryOperators.put("<", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "<", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 13 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) < 0;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }
            });
            binaryOperators.put("<=", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "<=", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 15 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) < 1;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }
            });
            binaryOperators.put(">", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, ">", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 17 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) > 0;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }
            });
            binaryOperators.put(">=", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, ">=", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 19 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) > -1;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }
            });
            binaryOperators.put("==", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "==", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 21 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            this.persistantResult.value = leftResult.equals(rightResult);
                            return this.persistantResult;
                        }
                    };
                }
            });
            binaryOperators.put("!=", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "!=", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value rightResult;
                            Value leftResult = this.leftChild.evaluate();
                            this.persistantResult.value = !leftResult.equals(rightResult = this.rightChild.evaluate());
                            return this.persistantResult;
                        }
                    };
                }
            });
            binaryOperators.put("&&", new BinaryOperatorCreator(-1){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "&&", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 25 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            try {
                                this.persistantResult.value = ((BooleanValue)leftResult).value && ((BooleanValue)rightResult).value;
                                return this.persistantResult;
                            }
                            catch (Exception e) {
                                return new ErrorValue("&& is not a valid operator for " + leftResult + " and " + rightResult);
                            }
                        }
                    };
                }
            });
            binaryOperators.put("||", new BinaryOperatorCreator(-1){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "||", left, right){
                        BooleanValue persistantResult;
                        final /* synthetic */ 27 this$1;
                        {
                            this.this$1 = var1_1;
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            try {
                                this.persistantResult.value = ((BooleanValue)leftResult).value || ((BooleanValue)rightResult).value;
                                return this.persistantResult;
                            }
                            catch (Exception e) {
                                return new ErrorValue("|| is not a valid operator for " + leftResult + " and " + rightResult);
                            }
                        }
                    };
                }
            });
            binaryOperators.put("?", new BinaryOperatorCreator(-3){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "?", left, right){
                        final /* synthetic */ 29 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            if (leftResult instanceof BooleanValue) {
                                if (this.rightChild instanceof CharacterSeparatedStatementPair && ((CharacterSeparatedStatementPair)this.rightChild).getSymbol().equals(":")) {
                                    if (((BooleanValue)leftResult).value) {
                                        return ((CharacterSeparatedStatementPair)this.rightChild).getLeftStatement().evaluate();
                                    }
                                    return ((CharacterSeparatedStatementPair)this.rightChild).getRightStatement().evaluate();
                                }
                                return new ErrorValue(this.rightChild + " should be a colon separated statement pair for the ? : operator");
                            }
                            return new ErrorValue(leftResult + " is an invalid condition for the ? : operator");
                        }
                    };
                }
            });
            binaryOperators.put(":", new BinaryOperatorCreator(-2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new CharacterSeparatedStatementPair(":", left, right);
                }
            });
            binaryOperators.put(";", new BinaryOperatorCreator(-5){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new CharacterSeparatedStatementPair(";", left, right);
                }
            });
            binaryOperators.put("=", new BinaryOperatorCreator(-4){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(this, "=", left, right){
                        final /* synthetic */ 33 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Value evaluate() {
                            Value rightValue = this.rightChild.evaluate();
                            try {
                                return ((Variable)this.leftChild).set(rightValue);
                            }
                            catch (Exception e) {
                                Value leftValue = this.leftChild.evaluate();
                                return new ErrorValue("'=' is not a valid operator for the types " + leftValue.getType() + " and " + rightValue.getType() + ", so " + leftValue + " = " + rightValue + " could not be evaluated");
                            }
                        }
                    };
                }
            });
        }
    }

    public static void getUnaryOperators(RecursiveDescentParser parent) {
        Operators.createAllUnaryOperators();
        Iterator it = unaryOperators.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            parent.addUnaryOperator((String)entry.getKey(), (UnaryOperatorCreator)entry.getValue());
        }
    }

    private static void createAllUnaryOperators() {
        if (unaryOperators == null) {
            unaryOperators = new HashMap();
            unaryOperators.put("sin", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "sin", child){
                        final /* synthetic */ 35 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.sin(x);
                        }
                    };
                }
            });
            unaryOperators.put("cos", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "cos", child){
                        final /* synthetic */ 37 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.cos(x);
                        }
                    };
                }
            });
            unaryOperators.put("tan", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "tan", child){
                        final /* synthetic */ 39 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.tan(x);
                        }
                    };
                }
            });
            unaryOperators.put("asin", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "asin", child){
                        final /* synthetic */ 41 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.asin(x);
                        }
                    };
                }
            });
            unaryOperators.put("acos", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "acos", child){
                        final /* synthetic */ 43 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.acos(x);
                        }
                    };
                }
            });
            unaryOperators.put("atan", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "atan", child){
                        final /* synthetic */ 45 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.atan(x);
                        }
                    };
                }
            });
            unaryOperators.put("cot", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "cot", child){
                        double HALF_PI;
                        final /* synthetic */ 47 this$1;
                        {
                            this.this$1 = var1_1;
                            this.HALF_PI = 1.5707963267948966;
                        }

                        double evaluate(double x) {
                            return Math.tan(this.HALF_PI - x);
                        }
                    };
                }
            });
            unaryOperators.put("sec", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "sec", child){
                        final /* synthetic */ 49 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return 1.0 / Math.cos(x);
                        }
                    };
                }
            });
            unaryOperators.put("csc", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "csc", child){
                        final /* synthetic */ 51 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return 1.0 / Math.sin(x);
                        }
                    };
                }
            });
            unaryOperators.put("ln", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "ln", child){
                        final /* synthetic */ 53 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.log(x);
                        }
                    };
                }
            });
            unaryOperators.put("log", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "ln", child){
                        double conversion;
                        final /* synthetic */ 55 this$1;
                        {
                            this.this$1 = var1_1;
                            this.conversion = Math.log(10.0);
                        }

                        double evaluate(double x) {
                            return (float)(Math.log(x) / this.conversion);
                        }
                    };
                }
            });
            unaryOperators.put("abs", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "abs", child){
                        final /* synthetic */ 57 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.abs(x);
                        }
                    };
                }
            });
            unaryOperators.put("sqrt", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "sqrt", child){
                        final /* synthetic */ 59 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.sqrt(x);
                        }
                    };
                }
            });
            unaryOperators.put("round", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "round", child){
                        final /* synthetic */ 61 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.round(x);
                        }
                    };
                }
            });
            unaryOperators.put("floor", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "floor", child){
                        final /* synthetic */ 63 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.floor(x);
                        }
                    };
                }
            });
            unaryOperators.put("ceil", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator(this, "ceil", child){
                        final /* synthetic */ 65 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        double evaluate(double x) {
                            return Math.ceil(x);
                        }
                    };
                }
            });
            unaryOperators.put("createFunction", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(this, child){
                        final /* synthetic */ 67 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Value evaluate() {
                            return new FunctionValue(this.child);
                        }

                        public String toString() {
                            return "createFunction(" + this.child + ")";
                        }
                    };
                }
            });
            unaryOperators.put("executeFunction", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(this, child){
                        final /* synthetic */ 69 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Value evaluate() {
                            Value value = this.child.evaluate();
                            if (value instanceof FunctionValue) {
                                return ((FunctionValue)value).executeFunction();
                            }
                            return new ErrorValue("executeFunction only takes a FunctionValue as an argument, not a " + value.getType());
                        }

                        public String toString() {
                            return "executeFunction(" + this.child + ")";
                        }
                    };
                }
            });
            unaryOperators.put("if", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(this, child){
                        FunctionValue associatedFunction;
                        final /* synthetic */ 71 this$1;
                        {
                            this.this$1 = var1_1;
                            this.associatedFunction = null;
                        }

                        public Value evaluate() {
                            Value condition = this.child.evaluate();
                            if (condition instanceof BooleanValue) {
                                if (((BooleanValue)condition).value) {
                                    if (this.associatedFunction != null) {
                                        this.associatedFunction.executeFunction();
                                        return NullValue.NULL;
                                    }
                                    return new ErrorValue("no associated function for \"if\" statement!");
                                }
                                return NullValue.NULL;
                            }
                            return new ErrorValue("the value " + condition + " is not a BooleanValue, so it is an invalid condition for an \"if\" statement");
                        }

                        public String toString() {
                            return "if(" + this.child + ")";
                        }

                        public boolean linkAssociatedFunction(FunctionValue associatedFunction) {
                            this.associatedFunction = associatedFunction;
                            return true;
                        }
                    };
                }
            });
            unaryOperators.put("while", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(this, child){
                        FunctionValue associatedFunction;
                        final /* synthetic */ 73 this$1;
                        {
                            this.this$1 = var1_1;
                            this.associatedFunction = null;
                        }

                        public Value evaluate() {
                            Value condition = this.child.evaluate();
                            if (condition instanceof BooleanValue) {
                                if (((BooleanValue)condition).value) {
                                    if (this.associatedFunction != null) {
                                        boolean conditionBoolean = true;
                                        try {
                                            while (conditionBoolean) {
                                                this.associatedFunction.executeFunction();
                                                conditionBoolean = ((BooleanValue)this.child.evaluate()).value;
                                            }
                                        }
                                        catch (Exception e) {
                                            return new ErrorValue("error occured in evaluating the condition " + this.child);
                                        }
                                        return NullValue.NULL;
                                    }
                                    return new ErrorValue("no associated function for \"while\" statement!");
                                }
                                return NullValue.NULL;
                            }
                            return new ErrorValue("the value " + condition + " is not a BooleanValue, so it is an invalid condition for a \"while\" statement");
                        }

                        public String toString() {
                            return "while(" + this.child + ")" + this.associatedFunction;
                        }

                        public boolean linkAssociatedFunction(FunctionValue associatedFunction) {
                            this.associatedFunction = associatedFunction;
                            return true;
                        }
                    };
                }
            });
            unaryOperators.put("for", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new ForLoop(child);
                }
            });
        }
    }
}

