/*
 * Decompiled with CFR 0.152.
 */
package grapher2D;

import generalMathClasses.CoordinateSpace2D;
import generalMathClasses.Window2D;
import grapher2D.Grapher2DModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import parser.ExpressionNode;
import parser.Value;
import valueTypes.DecimalValue;
import variables.Variable;

public class Grapher2DView
extends JPanel
implements Observer,
Runnable,
ComponentListener {
    private static final long serialVersionUID = 6185291782620102768L;
    Window2D window = new Window2D(Grapher2DModel.getInstance().getCoordinateSpace());
    Grapher2DModel model = Grapher2DModel.getInstance();
    ExpressionNode functionEvaluationTree = null;
    ExpressionNode tIncrementExpression = Grapher2DModel.getInstance().getParser().parse("t = t +0.1");
    Variable xVar = Variable.getVariable("x");
    Variable tVar = Variable.getVariable("t");
    Variable yVar = Variable.getVariable("y");
    boolean error = false;
    String errorMessage = "";
    CoordinateSpace2D coordinateSpace;
    double maxMinusMinX;
    double xVal;
    double yVal;
    DecimalValue xDecimalValue = new DecimalValue(0.0);
    int numPoints = 0;
    int i;
    Point[] points = new Point[0];
    Value result;
    Dimension size = new Dimension();

    public Grapher2DView() {
        new Thread(this).start();
        this.addComponentListener(this);
    }

    public void paint(Graphics g) {
        g.clearRect(0, 0, this.size.width, this.size.height);
        if (this.error) {
            this.drawErrorMessage((Graphics2D)g, this.errorMessage, this.size.width);
        } else {
            int i = 0;
            while (i < this.numPoints - 1) {
                g.drawLine(this.points[i].x, this.points[i].y, this.points[i + 1].x, this.points[i + 1].y);
                ++i;
            }
        }
    }

    public void drawErrorMessage(Graphics2D g, String message, float width) {
        LineBreakMeasurer linebreaker = new LineBreakMeasurer(new AttributedString(message).getIterator(), g.getFontRenderContext());
        g.setColor(Color.red);
        float y = 0.0f;
        while (linebreaker.getPosition() < message.length()) {
            TextLayout tl = linebreaker.nextLayout(width);
            tl.draw(g, 0.0f, y += tl.getAscent());
            y += tl.getDescent() + tl.getLeading();
        }
    }

    public void update(Observable o, Object arg) {
        this.updateSizes();
    }

    private void updateSizes() {
        this.size = this.getSize();
        this.window.set(this.size);
        int newNumPoints = this.model.getGraphResolution();
        if (newNumPoints != this.numPoints) {
            this.numPoints = newNumPoints;
            this.points = new Point[this.numPoints];
        }
    }

    private void calculatePoints() {
        this.functionEvaluationTree = this.model.getFunctionEvaluationTree();
        if (this.functionEvaluationTree == null) {
            this.error = true;
            this.errorMessage = "There is no function to display";
            return;
        }
        this.error = false;
        this.coordinateSpace = this.window.getCoordinateSpace();
        this.maxMinusMinX = this.coordinateSpace.xMax - this.coordinateSpace.xMin;
        this.i = 0;
        while (this.i < this.numPoints) {
            this.xDecimalValue.value = this.xVal = (double)this.i / (double)this.numPoints * this.maxMinusMinX + this.coordinateSpace.xMin;
            this.xVar.set(this.xDecimalValue);
            this.functionEvaluationTree.evaluate();
            this.result = this.yVar.evaluate();
            this.points[this.i] = new Point();
            if (!(this.result instanceof DecimalValue)) {
                this.error = true;
                this.errorMessage = this.result.toString();
                return;
            }
            this.error = false;
            this.yVal = ((DecimalValue)this.result).value;
            this.points[this.i].x = this.window.getXpixel(this.xVal);
            this.points[this.i].y = this.window.getYpixel(this.yVal);
            ++this.i;
        }
    }

    public void run() {
        while (true) {
            boolean animate;
            if (animate = this.model.getAnimate()) {
                this.calculatePoints();
                this.repaint();
                this.tIncrementExpression.evaluate();
            }
            try {
                Thread.sleep(this.error || !animate ? 200 : 20);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.updateSizes();
    }

    public void componentShown(ComponentEvent e) {
    }
}

