/*
 * Decompiled with CFR 0.152.
 */
package grapher2D;

import generalMathClasses.CoordinateSpace2D;
import java.util.Observable;
import parser.ExpressionNode;
import parser.RecursiveDescentParser;

public class Grapher2DModel
extends Observable {
    String functionString = "";
    private RecursiveDescentParser parser = new RecursiveDescentParser();
    private ExpressionNode functionEvaluationTree;
    ExpressionNode tResetExpression;
    CoordinateSpace2D coordinateSpace = new CoordinateSpace2D(-10.0, 10.0, -10.0, 10.0);
    int graphResolution = 500;
    boolean animate;
    static Grapher2DModel INSTANCE = null;

    private Grapher2DModel() {
        this.functionEvaluationTree = this.parser.parse("executeFunction(grapher2DFunction)");
        this.tResetExpression = this.parser.parse("t = 0");
    }

    public static Grapher2DModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Grapher2DModel();
        }
        return INSTANCE;
    }

    CoordinateSpace2D getCoordinateSpace() {
        return this.coordinateSpace;
    }

    public int getGraphResolution() {
        return this.graphResolution;
    }

    RecursiveDescentParser getParser() {
        return this.parser;
    }

    ExpressionNode getFunctionEvaluationTree() {
        return this.functionEvaluationTree;
    }

    public void setFunctionString(String functionString) {
        this.functionString = functionString;
        this.parser.parse("grapher2DFunction = {" + this.functionString + "}").evaluate();
        this.tResetExpression.evaluate();
        this.setChanged();
        this.notifyObservers();
    }

    public String getFunctionString() {
        return this.functionString;
    }

    public void setAnimate(boolean b) {
        this.animate = b;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean getAnimate() {
        return this.animate;
    }
}

