/*
 * Decompiled with CFR 0.152.
 */
package grapher2D;

import grapher2D.Grapher2DController;
import grapher2D.Grapher2DModel;
import grapher2D.Grapher2DView;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class Grapher2DGUI
extends JFrame
implements ActionListener,
WindowFocusListener {
    private static final long serialVersionUID = 7205295946430619788L;
    Grapher2DModel model = Grapher2DModel.getInstance();

    public Grapher2DGUI(Dimension frameSize) {
        Grapher2DController controller = new Grapher2DController();
        Grapher2DView view = new Grapher2DView();
        this.model.addObserver(controller);
        this.model.addObserver(view);
        this.model.setFunctionString("a = sin(t/5); y = x>0?(sin(x*10-t)+3*sin(x/4+t)+2*sin(x-t))*a:sin(x+t)*x*a");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        content.add(new JSplitPane(0, controller, view));
        this.getContentPane().add(content);
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("Examples");
        fileMenu.add(this.constructExampleMenuItem("Simple sine wave", "y = sin(x)"));
        fileMenu.add(this.constructExampleMenuItem("Time", "y = sin(x+t)"));
        fileMenu.add(this.constructExampleMenuItem("Variables", "a = sin(4*x); b = 2*sin(x/2);y = a+b"));
        fileMenu.add(this.constructExampleMenuItem("Binary Operators", "y = 1+2-3*4/5^6E-7%8!"));
        fileMenu.add(this.constructExampleMenuItem("Trigonometry", "y = sin(3)+cos(5)+tan(5)+cot(.5)+sec(.5)+csc(.5)+asin(0.5)+acos(.5)+atan(.5)"));
        fileMenu.add(this.constructExampleMenuItem("Other Operators", "y = ln(5)+log(1000)+abs(-5)+sqrt(25)+round(6.5)+floor(6.6)+ceil(6.4)-30"));
        fileMenu.add(this.constructExampleMenuItem("Constants", "y = pi+e+1/Infinity"));
        fileMenu.add(this.constructExampleMenuItem("Conditional", "y = x<1?5^x:5"));
        fileMenu.add(this.constructExampleMenuItem("Boolean Algebra", "y = (x<1&&x>-1)||x>8?5:-5"));
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        this.setDefaultCloseOperation(3);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("icon.gif"));
        this.setTitle("2D Grapher");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(new Rectangle(new Point(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2), frameSize));
        this.addWindowFocusListener(this);
    }

    private JMenuItem constructExampleMenuItem(String menuText, String functionString) {
        JMenuItem simple = new JMenuItem(menuText);
        simple.setActionCommand(functionString);
        simple.addActionListener(this);
        simple.setVisible(true);
        return simple;
    }

    public void actionPerformed(ActionEvent e) {
        this.model.setFunctionString(e.getActionCommand());
    }

    public void windowGainedFocus(WindowEvent e) {
        this.model.setAnimate(true);
    }

    public void windowLostFocus(WindowEvent e) {
        this.model.setAnimate(false);
    }
}

