/*
 * Decompiled with CFR 0.152.
 */
package generalMathClasses;

import generalMathClasses.CoordinateSpace2D;
import java.awt.Dimension;
import java.awt.Rectangle;

public class Window2D {
    int height;
    int width;
    CoordinateSpace2D coordinateSpace;

    public Window2D(int w, int h, double Xm, double xM, double Ym, double yM) {
        this.height = h;
        this.width = w;
        this.coordinateSpace = new CoordinateSpace2D(Xm, xM, Ym, yM);
    }

    public Window2D(int w, int h) {
        this.height = h;
        this.width = w;
        this.coordinateSpace.xMin = -10.0;
        this.coordinateSpace.xMax = 10.0;
        this.coordinateSpace.yMin = -10.0;
        this.coordinateSpace.yMax = 10.0;
    }

    public Window2D() {
        this(0, 0, 0.0, 0.0, 0.0, 0.0);
    }

    public Window2D(CoordinateSpace2D coordinateSpace) {
        this.coordinateSpace = coordinateSpace;
        this.height = 0;
        this.width = 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public CoordinateSpace2D getCoordinateSpace() {
        return this.coordinateSpace;
    }

    public void set(double Xm, double xM, double Ym, double yM) {
        this.coordinateSpace.xMin = Xm;
        this.coordinateSpace.xMax = xM;
        this.coordinateSpace.yMin = Ym;
        this.coordinateSpace.yMax = yM;
    }

    public void set(int w, int h) {
        this.height = h;
        this.width = w;
    }

    public void set(Dimension newPixelSpace) {
        this.height = newPixelSpace.height;
        this.width = newPixelSpace.width;
    }

    public void zoom(Rectangle zoomBox) {
        double x1 = zoomBox.getX();
        double y1 = zoomBox.getY();
        this.set(this.getXvalue(x1), this.getXvalue(x1 + zoomBox.getWidth()), this.getYvalue(y1 + zoomBox.getHeight()), this.getYvalue(y1));
    }

    public int getXpixel(double xVal) {
        return (int)((xVal - this.coordinateSpace.xMin) * ((double)this.width / (this.coordinateSpace.xMax - this.coordinateSpace.xMin)));
    }

    public int getYpixel(double yVal) {
        return this.height - (int)((yVal - this.coordinateSpace.yMin) * ((double)this.height / (this.coordinateSpace.yMax - this.coordinateSpace.yMin)));
    }

    public double getXvalue(double xPix) {
        return xPix * ((this.coordinateSpace.xMax - this.coordinateSpace.xMin) / (double)this.width) + this.coordinateSpace.xMin;
    }

    public double getYvalue(double yPix) {
        return ((double)this.height - yPix) / (double)this.height * (this.coordinateSpace.yMax - this.coordinateSpace.yMin) + this.coordinateSpace.yMin;
    }
}

