/*
 * Decompiled with CFR 0.152.
 */
package variables;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import parser.ExpressionNode;
import parser.Value;
import valueTypes.DecimalValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
extends ExpressionNode {
    String name;
    Value value;
    boolean hasObservers = false;
    public boolean modifiable = true;
    ObservableVariableInternalObservable internalObservable = null;
    static Map<String, Variable> variables = new HashMap<String, Variable>();
    Map<Observer, String> observerExplainations = new HashMap<Observer, String>();
    private long timeOfLastChange = 0L;

    protected Variable(String name) {
        this.name = name;
        this.value = new DecimalValue(0.0);
    }

    public static Variable getVariable(String variableName) {
        Variable variable = variables.get(variableName);
        if (variable != null) {
            return variable;
        }
        Variable newVariable = new Variable(variableName);
        variables.put(variableName, newVariable);
        return newVariable;
    }

    @Override
    public Value evaluate() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public static Map<String, Variable> getSymbolTable() {
        return variables;
    }

    public void addObserver(Observer o, String explaination) {
        this.observerExplainations.put(o, explaination);
        if (this.internalObservable == null) {
            this.internalObservable = new ObservableVariableInternalObservable();
        }
        this.internalObservable.addObserver(o);
        this.hasObservers = true;
    }

    public void deleteObserver(Observer o) {
        this.internalObservable.deleteObserver(o);
        this.observerExplainations.remove(o);
    }

    public Value set(Value value) {
        if (this.modifiable) {
            this.value = value;
            if (this.hasObservers) {
                this.internalObservable.setChangedAndNotifyObservers(this);
            }
            this.timeOfLastChange = System.currentTimeMillis();
        }
        return this.value;
    }

    public Collection<String> getObserverExplainations() {
        return this.observerExplainations.values();
    }

    public boolean hasObservers() {
        return this.hasObservers;
    }

    public long getTimeOfLastChange() {
        return this.timeOfLastChange;
    }

    private class ObservableVariableInternalObservable
    extends Observable {
        private ObservableVariableInternalObservable() {
        }

        public void setChangedAndNotifyObservers(Variable variableWhichChanged) {
            this.setChanged();
            this.notifyObservers(variableWhichChanged);
        }
    }
}

