/*
 * Decompiled with CFR 0.152.
 */
package variables;

import valueTypes.BooleanValue;
import valueTypes.DecimalValue;
import valueTypes.NullValue;
import variables.Constant;

public class Constants {
    private static boolean constantsHaveBeenInitialized = false;

    public static void initializeConstants() {
        if (!constantsHaveBeenInitialized) {
            Constant.createConstant("pi", new DecimalValue(Math.PI), "the ratio of circumference to diameter of a circle");
            Constant.createConstant("e", new DecimalValue(Math.E), "the base of natural logarithms, often called Euler's number or Napier's constant");
            Constant.createConstant("Infinity", new DecimalValue(Double.POSITIVE_INFINITY), "the value representing positive infinity. It will behave like infinity in calculations");
            Constant.createConstant("true", new BooleanValue(true), "the boolean value true");
            Constant.createConstant("false", new BooleanValue(false), "the boolean value false");
            Constant.createConstant("null", NullValue.NULL, "the value representing null, or nothing");
            constantsHaveBeenInitialized = true;
        }
    }
}

