/*
 * Decompiled with CFR 0.152.
 */
package variableEditorUI;

import java.awt.Window;
import java.util.Iterator;
import java.util.LinkedList;
import logEnabledComponents.LogEnabledJFrame;
import operators.UnaryOperator;
import operators.UnaryOperatorCreator;
import parser.ExpressionNode;
import parser.RecursiveDescentParser;
import parser.Value;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ErrorValue;
import valueTypes.StringValue;
import variableEditorUI.VariableEditorUI;
import variables.Variable;

public class VariableEditorUICommand
implements UnaryOperatorCreator {
    private VariableEditorUICommand() {
    }

    public static void setUpEditVariablesCommand(RecursiveDescentParser parser) {
        parser.addUnaryOperator("edit", new VariableEditorUICommand());
    }

    public UnaryOperator create(ExpressionNode child) {
        return new UnaryOperator(child){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Value evaluate() {
                LinkedList<Variable> variables = new LinkedList<Variable>();
                if (this.child instanceof Variable) {
                    variables.add((Variable)this.child);
                } else {
                    if (!(this.child instanceof CharacterSeparatedStatementPair)) return new ErrorValue("edit(var1, var2, var3 ...) takes only variables as arguments. " + this.child.toString() + " is an invalid argument");
                    CharacterSeparatedStatementPair listOfVariables = (CharacterSeparatedStatementPair)this.child;
                    if (!listOfVariables.getSymbol().equals(",")) return new ErrorValue("edit(var1, var2, var3 ...) takes only variables separated by commas as arguments. " + listOfVariables.getSymbol() + " is an invalid argument separator");
                    ExpressionNode[] allVariables = ((CharacterSeparatedStatementPair)this.child).extractAllStatements();
                    int i = 0;
                    while (i < allVariables.length) {
                        if (!(allVariables[i] instanceof Variable)) {
                            return new ErrorValue("edit(var1, var2, var3 ...) takes only variables as arguments. Argument number " + (i + 1) + ", " + allVariables[i].toString() + ", is an invalid argument");
                        }
                        variables.add((Variable)allVariables[i]);
                        ++i;
                    }
                }
                VariableEditorUI editorUI = new VariableEditorUI(variables);
                StringBuffer buff = new StringBuffer();
                Iterator it = variables.iterator();
                while (it.hasNext()) {
                    buff.append(String.valueOf(((Variable)it.next()).toString()) + (it.hasNext() ? "_" : ""));
                }
                LogEnabledJFrame frame = new LogEnabledJFrame("VariableEditorFrameForVariables_" + buff.toString());
                frame.setTitle("Variable Editor");
                frame.setBounds(200, 200, 300, editorUI.getPreferredSize().height + 30);
                frame.getContentPane().add(editorUI);
                frame.setDefaultCloseOperation(2);
                ((Window)frame).setVisible(true);
                return new StringValue("Successfully created variable editor.");
            }
        };
    }

    public int getType() {
        return 3;
    }

    public String getDescription() {
        return "takes an arbitrary number of variables as arguments and pops up a frame which has in it real time graphical editors for all of the argument variables. For example \"edit(a,b,c)\"";
    }
}

