/*
 * Decompiled with CFR 0.152.
 */
package variableEditorUI;

import colorMapValue.ColorMapValue;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import parser.Value;
import valueTypes.BooleanValue;
import valueTypes.ColorValue;
import valueTypes.DecimalValue;
import valueTypes.IntegerValue;
import variableEditorTypes.BasicVariableEditorPanel;
import variableEditorTypes.BooleanValueEditorPanel;
import variableEditorTypes.ColorMapValueEditorPanel;
import variableEditorTypes.ColorValueEditorPanel;
import variableEditorTypes.DecimalValueEditorPanel;
import variableEditorTypes.IndividualVariableEditorPanel;
import variableEditorTypes.IntegerValueEditorPanel;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableEditorPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = -4730265945673395759L;
    Variable variable;
    IndividualVariableEditorPanel editorPanel;

    public VariableEditorPanel(Variable variable) {
        this.variable = variable;
        this.setLayout(new GridLayout(1, 0));
        this.assignTypeSpecificEditorPanel();
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
    }

    private void assignTypeSpecificEditorPanel() {
        Value value = this.variable.evaluate();
        this.editorPanel = value instanceof DecimalValue ? (value instanceof IntegerValue ? new IntegerValueEditorPanel(this.variable) : new DecimalValueEditorPanel(this.variable)) : (value instanceof BooleanValue ? new BooleanValueEditorPanel(this.variable) : (value instanceof ColorValue ? new ColorValueEditorPanel(this.variable) : (value instanceof ColorMapValue ? new ColorMapValueEditorPanel(this.variable) : new BasicVariableEditorPanel(this.variable))));
        this.removeAll();
        this.add(this.editorPanel);
        this.validate();
    }

    public void update(Observable o, Object arg) {
        if (o == VariableEditorUIUpdateThread.getInstance()) {
            if (!this.isDisplayable()) {
                VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
            } else if (this.editorPanel.hasTypeConflict()) {
                this.assignTypeSpecificEditorPanel();
            }
        }
    }
}

