/*
 * Decompiled with CFR 0.152.
 */
package variableEditorUI;

import expressionConsole.ExpressionConsoleModel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import parser.ExpressionNode;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ErrorValue;
import variables.Variable;

public class EditVariablesMenuPanel
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = -9092708506771144827L;
    JTextField textField = new JTextField();

    public EditVariablesMenuPanel() {
        this.textField.addKeyListener(this);
        this.add(new JSplitPane(0, new JLabel("Variable(s) to edit...(ex. \"a, b, c\")"), this.textField));
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            if (this.textIsValid()) {
                ExpressionConsoleModel.getInstance().enterExpression("edit(" + this.textField.getText() + ")");
            } else {
                JOptionPane.showMessageDialog(this, "Invalid text! " + this.textField.getText() + " is not a comma separated list of variable names.", "Invalid text!", 0);
            }
            this.textField.setText("");
        }
    }

    private boolean textIsValid() {
        ExpressionNode evalTree = ExpressionConsoleModel.getInstance().getParser().parse(this.textField.getText());
        if (evalTree instanceof CharacterSeparatedStatementPair) {
            CharacterSeparatedStatementPair statements = (CharacterSeparatedStatementPair)evalTree;
            if (statements.getSymbol().equals(",")) {
                ExpressionNode[] allVars = statements.extractAllStatements();
                return allVars.length != 1 || !(allVars[0] instanceof ErrorValue);
            }
            return false;
        }
        return evalTree instanceof Variable;
    }

    public void keyReleased(KeyEvent e) {
    }
}

