/*
 * Decompiled with CFR 0.152.
 */
package variableEditorTypes;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JSplitPane;
import parser.Value;
import variableEditorComponents.VariableBoundTextField;
import variableEditorComponents.VariableBoundTitledBorder;
import variableEditorComponents.VariableEditorComponent;
import variableEditorTypes.IndividualVariableEditorPanel;
import variables.Variable;

public class BasicVariableEditorPanel
extends IndividualVariableEditorPanel {
    private static final long serialVersionUID = -4715753465310426790L;
    protected Variable variable;
    Value initialValue;

    public BasicVariableEditorPanel(Variable variable) {
        this.variable = variable;
        this.initialValue = variable.evaluate();
        this.setLayout(new GridLayout(1, 0));
        VariableBoundTitledBorder border = new VariableBoundTitledBorder(variable, this, this.displayValueInBorder());
        VariableBoundTextField textField = new VariableBoundTextField(variable);
        textField.bindToVariableEditorComponent(border);
        this.setBorder(border);
        VariableEditorComponent typeSpecificComponent = this.getTypeSpecificComponent();
        if (typeSpecificComponent == null) {
            this.add(textField);
        } else if (typeSpecificComponent instanceof Component) {
            textField.bindToVariableEditorComponent(typeSpecificComponent);
            typeSpecificComponent.bindToVariableEditorComponent(border);
            typeSpecificComponent.bindToVariableEditorComponent(textField);
            JSplitPane split = new JSplitPane(1, (Component)((Object)typeSpecificComponent), textField);
            split.setResizeWeight(1.0);
            if (!this.showTextFieldInitially()) {
                split.setDividerLocation(1000);
            }
            this.add(split);
        } else {
            new Exception("typeSpecificComponent is not a Component").printStackTrace();
        }
    }

    public boolean hasTypeConflict() {
        return this.initialValue.getClass() != this.variable.evaluate().getClass();
    }

    protected VariableEditorComponent getTypeSpecificComponent() {
        return null;
    }

    protected boolean showTextFieldInitially() {
        return false;
    }

    protected boolean displayValueInBorder() {
        return false;
    }
}

