/*
 * Decompiled with CFR 0.152.
 */
package variableEditorComponents;

import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import variableEditorComponents.VariableEditorComponent;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableBoundTitledBorder
extends TitledBorder
implements Observer,
VariableEditorComponent {
    private static final long serialVersionUID = -2182294459528860891L;
    Variable variable;
    JComponent parent = null;
    String displayedValue = "";
    private boolean displayVariableValueInTitle = true;

    public VariableBoundTitledBorder(Variable variable, JComponent parent) {
        super("");
        this.variable = variable;
        this.parent = parent;
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
        this.updateWithCurrentVariableValue();
    }

    public VariableBoundTitledBorder(Variable variable, JComponent parent, boolean displayVariableValueInTitle) {
        this(variable, parent);
        this.displayVariableValueInTitle = displayVariableValueInTitle;
        this.updateWithCurrentVariableValue();
    }

    public void updateWithCurrentVariableValue() {
        String valueString = this.variable.evaluate().toParseableString();
        this.setTitle(String.valueOf(this.variable.toString().replace('_', ' ')) + (this.displayVariableValueInTitle ? " : " + valueString : ""));
        this.displayedValue = valueString;
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    public void update(Observable o, Object arg) {
        if (o == VariableEditorUIUpdateThread.getInstance()) {
            if (this.parent != null) {
                if (!this.parent.isDisplayable()) {
                    VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
                } else if (!this.variable.evaluate().toParseableString().equals(this.displayedValue)) {
                    this.updateWithCurrentVariableValue();
                }
            } else {
                VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
            }
        }
    }

    public void bindToVariableEditorComponent(VariableEditorComponent componentToUpdate) {
    }

    public void setDisplayValue(boolean displayVariableValueInTitle) {
        this.displayVariableValueInTitle = displayVariableValueInTitle;
    }
}

