/*
 * Decompiled with CFR 0.152.
 */
package variableEditorComponents;

import expressionConsole.ExpressionConsoleModel;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import parser.RecursiveDescentParser;
import parser.Value;
import variableEditorComponents.VariableEditorComponent;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableBoundTextField
extends JTextField
implements KeyListener,
Observer,
VariableEditorComponent {
    private static final long serialVersionUID = 7668831707610334469L;
    Variable variable;
    RecursiveDescentParser parser = ExpressionConsoleModel.getInstance().getParser();
    String displayedValue = "";

    public VariableBoundTextField(Variable variable) {
        this.variable = variable;
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
        this.addKeyListener(this);
        this.updateWithCurrentVariableValue();
        this.setUpUndoRedo();
    }

    private void setUpUndoRedo() {
        final UndoManager undo = new UndoManager();
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent evt) {
                undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canUndo()) {
                        undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (undo.canRedo()) {
                        undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
    }

    protected void processInputText(String text) {
        ExpressionConsoleModel.getInstance().enterExpression(String.valueOf(this.variable.toString()) + " = " + this.getText());
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\n') {
            this.processInputText(this.getText());
        }
        this.displayedValue = this.getText();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void update(Observable o, Object arg) {
        if (o == VariableEditorUIUpdateThread.getInstance()) {
            if (!this.isDisplayable()) {
                VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
            } else if (!this.variable.evaluate().toParseableString().equals(this.displayedValue) && !this.hasFocus()) {
                this.updateWithCurrentVariableValue();
            }
        } else if (arg == this.variable) {
            this.updateWithCurrentVariableValue();
        }
    }

    public void updateWithCurrentVariableValue() {
        Value currentValue = this.variable.evaluate();
        this.displayedValue = currentValue.toParseableString();
        this.setText(this.displayedValue);
        this.setCaretPosition(0);
    }

    public void bindToVariableEditorComponent(VariableEditorComponent componentToUpdate) {
        private class ComponentKeyListener
        implements KeyListener {
            VariableEditorComponent componentToUpdate;

            public ComponentKeyListener(VariableEditorComponent componentToUpdate) {
                this.componentToUpdate = componentToUpdate;
            }

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    this.componentToUpdate.updateWithCurrentVariableValue();
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        }
        this.addKeyListener(new ComponentKeyListener(componentToUpdate));
    }

    public void setUpAsDirectObserver(String explaination) {
        VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
        this.variable.addObserver(this, explaination);
    }
}

