/*
 * Decompiled with CFR 0.152.
 */
package variableEditorComponents;

import expressionConsole.ExpressionConsoleModel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import valueTypes.DecimalValue;
import variableEditorComponents.VariableEditorComponent;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableBoundDecimalSlider
extends JSlider
implements ChangeListener,
MouseListener,
Observer,
VariableEditorComponent {
    private static final long serialVersionUID = -7777499408692975081L;
    Variable variable;
    static final int SLIDERSCALE = 800;
    double minValue = 0.0;
    double maxValue = 10.0;
    boolean ignoreSliderChange = false;
    DecimalValue reusableValue = new DecimalValue(0.0);
    String displayedValue = "";
    protected double maxValueForZeroValue = 1.0;
    protected double minValueForZeroValue = -1.0;

    public VariableBoundDecimalSlider(Variable variable) {
        this.variable = variable;
        this.addMouseListener(this);
        this.setMaximum(800);
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
        this.updateWithCurrentVariableValue();
        this.addChangeListener(this);
    }

    public void updateWithCurrentVariableValue() {
        double currentValue = DecimalValue.extractDoubleValue(this.variable.evaluate());
        this.maxValue = currentValue * 2.0;
        this.minValue = 0.0;
        if (this.maxValue == 0.0) {
            this.maxValue = this.maxValueForZeroValue;
            this.minValue = this.minValueForZeroValue;
        } else if (this.maxValue < 0.0) {
            this.minValue = this.maxValue;
            this.maxValue = 0.0;
        }
        this.ignoreSliderChange = true;
        this.setValue((int)((currentValue - this.minValue) / (this.maxValue - this.minValue) * 800.0));
        this.ignoreSliderChange = false;
        this.displayedValue = "" + currentValue;
    }

    public void stateChanged(ChangeEvent a) {
        if (!this.ignoreSliderChange) {
            this.reusableValue.value = this.getCurrentSliderValue();
            this.variable.set(this.reusableValue);
            this.displayedValue = this.reusableValue.toParseableString();
        }
    }

    protected double getCurrentSliderValue() {
        return this.minValue + (double)this.getValue() / 800.0 * (this.maxValue - this.minValue);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        ExpressionConsoleModel.getInstance().enterExpression(String.valueOf(this.variable.toString()) + " = " + this.variable.evaluate().toParseableString());
        this.updateWithCurrentVariableValue();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void update(Observable o, Object arg) {
        if (o == VariableEditorUIUpdateThread.getInstance()) {
            if (!this.isDisplayable()) {
                VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
            } else if (!this.variable.evaluate().toParseableString().equals(this.displayedValue) && !this.getValueIsAdjusting()) {
                this.updateWithCurrentVariableValue();
            }
        }
    }

    public void bindToVariableEditorComponent(VariableEditorComponent componentToUpdate) {
        final VariableEditorComponent componentToReallyUpdate = componentToUpdate;
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                componentToReallyUpdate.updateWithCurrentVariableValue();
            }
        });
    }
}

