/*
 * Decompiled with CFR 0.152.
 */
package variableEditorComponents;

import expressionConsole.ExpressionConsoleModel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import valueTypes.ColorValue;
import variableEditorComponents.VariableEditorComponent;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableBoundColorBox
extends JPanel
implements Observer,
VariableEditorComponent,
MouseListener {
    private static final long serialVersionUID = -7777499408692975081L;
    Variable variable;
    String displayedValue = "";

    public VariableBoundColorBox(Variable variable) {
        this.variable = variable;
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
        this.updateWithCurrentVariableValue();
        this.addMouseListener(this);
    }

    public void updateWithCurrentVariableValue() {
        this.setBackground(ColorValue.extractColor(this.variable.evaluate()));
        this.displayedValue = this.variable.evaluate().toParseableString();
    }

    public void update(Observable o, Object arg) {
        if (o == VariableEditorUIUpdateThread.getInstance()) {
            if (!this.isDisplayable()) {
                VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
            } else if (!this.variable.evaluate().toParseableString().equals(this.displayedValue)) {
                this.updateWithCurrentVariableValue();
            }
        }
    }

    public void bindToVariableEditorComponent(VariableEditorComponent componentToUpdate) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public void mouseReleased(MouseEvent e) {
        if (this.contains(e.getPoint())) {
            this.setBorder(BorderFactory.createBevelBorder(0));
            Color color = JColorChooser.showDialog(this, "Choose Color", this.getBackground());
            if (color != null) {
                ExpressionConsoleModel.getInstance().enterExpression(String.valueOf(this.variable.toString()) + " = " + new ColorValue(color).toParseableString());
                this.updateWithCurrentVariableValue();
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.setBorder(BorderFactory.createBevelBorder(0));
    }

    public void mouseExited(MouseEvent e) {
        this.setBorder(null);
    }
}

