/*
 * Decompiled with CFR 0.152.
 */
package variableEditorComponents;

import expressionConsole.ExpressionConsoleModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import valueTypes.BooleanValue;
import variableEditorComponents.VariableEditorComponent;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableBoundCheckBox
extends JCheckBox
implements Observer,
ItemListener,
VariableEditorComponent {
    private static final long serialVersionUID = -7777499408692975081L;
    Variable variable;
    String displayedValue = "";
    boolean ignoreUpdates = false;

    public VariableBoundCheckBox(Variable variable) {
        super(variable.toString());
        this.variable = variable;
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
        this.updateWithCurrentVariableValue();
        this.addItemListener(this);
    }

    public void updateWithCurrentVariableValue() {
        this.ignoreUpdates = true;
        this.setSelected(BooleanValue.extractBooleanValue(this.variable.evaluate()));
        this.displayedValue = this.variable.evaluate().toParseableString();
        this.ignoreUpdates = false;
    }

    public void update(Observable o, Object arg) {
        if (o == VariableEditorUIUpdateThread.getInstance()) {
            if (!this.isDisplayable()) {
                VariableEditorUIUpdateThread.getInstance().deleteObserver(this);
            } else if (!this.variable.evaluate().toParseableString().equals(this.displayedValue)) {
                this.updateWithCurrentVariableValue();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.ignoreUpdates) {
            this.variable.set(new BooleanValue(e.getStateChange() == 1));
            this.displayedValue = this.variable.evaluate().toParseableString();
            ExpressionConsoleModel.getInstance().enterExpression(String.valueOf(this.variable.toString()) + " = " + this.displayedValue);
        }
    }

    public void bindToVariableEditorComponent(VariableEditorComponent componentToUpdate) {
        private class ComponentChangeListener
        implements ChangeListener {
            VariableEditorComponent componentToUpdate;

            public ComponentChangeListener(VariableEditorComponent componentToUpdate) {
                this.componentToUpdate = componentToUpdate;
            }

            public void stateChanged(ChangeEvent e) {
                this.componentToUpdate.updateWithCurrentVariableValue();
            }
        }
        this.addChangeListener(new ComponentChangeListener(componentToUpdate));
    }
}

