/*
 * Decompiled with CFR 0.152.
 */
package variableBridge;

import expressionConsole.ExpressionConsoleModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import variableBridge.IndividualVariableBridge;
import variableBridge.VariableBridgeImplementation;
import variableEditorUI.VariableEditorUIUpdateThread;
import variables.Variable;

public class VariableBridge
implements Observer {
    Variable[] variables;
    Map<String, VariableBridgeImplementation> individualVariableUpdaters = new HashMap<String, VariableBridgeImplementation>();

    public VariableBridge(IndividualVariableBridge[] bridges) {
        this.variables = new Variable[bridges.length];
        int i = 0;
        while (i < bridges.length) {
            this.variables[i] = Variable.getVariable(bridges[i].variableName);
            this.individualVariableUpdaters.put(bridges[i].variableName, bridges[i].bridgeImplementation);
            this.variables[i].addObserver(this, bridges[i].explaination);
            ++i;
        }
        this.updateExternalVariables();
        VariableEditorUIUpdateThread.getInstance().addObserver(this);
    }

    public void updateExternalVariables() {
        int i = 0;
        while (i < this.variables.length) {
            if (!this.updateExternalVariable(this.variables[i])) {
                new Exception("The variable bridged class does not handle the Variable " + this.variables[i] + ", but it should!").printStackTrace();
            }
            ++i;
        }
    }

    public void updateInternalVariables() {
        int i = 0;
        while (i < this.variables.length) {
            if (!this.updateInternalVariable(this.variables[i])) {
                new Exception("The variable bridged class does not handle the Variable " + this.variables[i] + ", but it should!").printStackTrace();
            }
            ++i;
        }
    }

    public boolean updateExternalVariable(Variable variable) {
        VariableBridgeImplementation u = this.individualVariableUpdaters.get(variable.toString());
        if (u != null) {
            u.updateExternalVariable(variable);
            return true;
        }
        return false;
    }

    public boolean updateInternalVariable(Variable variable) {
        VariableBridgeImplementation u = this.individualVariableUpdaters.get(variable.toString());
        if (u != null) {
            u.updateInternalVariable(variable);
            return true;
        }
        return false;
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof Variable) {
            if (this.individualVariableUpdaters.containsKey(arg.toString())) {
                this.updateInternalVariable((Variable)arg);
            }
        } else if (arg == VariableEditorUIUpdateThread.UPDATE_ARGUMENT) {
            this.updateExternalVariables();
        }
    }

    public void showEditorForAllVariables() {
        StringBuffer editCommand = new StringBuffer();
        editCommand.append("edit(");
        int i = 0;
        while (i < this.variables.length) {
            editCommand.append(String.valueOf(this.variables[i].toString()) + (i < this.variables.length - 1 ? "," : ""));
            ++i;
        }
        editCommand.append(")");
        ExpressionConsoleModel.getInstance().enterExpression(editCommand.toString());
    }
}

