/*
 * Decompiled with CFR 0.152.
 */
package valueTypes;

import java.awt.Color;
import parser.Value;

public class ColorValue
extends Value {
    public Color value;

    public ColorValue(Color value) {
        this.set(value);
    }

    public ColorValue(double r, double g, double b) {
        this.set(r, g, b);
    }

    public String getType() {
        return "Color";
    }

    public Color toColor() {
        return this.value;
    }

    public String toString() {
        return this.toParseableString();
    }

    public String toParseableString() {
        return ColorValue.generateParseableString(this.value);
    }

    public boolean equals(Object o) {
        return o instanceof ColorValue ? this.value.equals(((ColorValue)o).value) : false;
    }

    public static Color extractColor(Value value) {
        return value instanceof ColorValue ? ((ColorValue)value).value : Color.GRAY;
    }

    public void set(double r, double g, double b) {
        this.set(new Color((int)(255.0 * (r > 1.0 ? 1.0 : (r < 0.0 ? 0.0 : r))), (int)(255.0 * (g > 1.0 ? 1.0 : (g < 0.0 ? 0.0 : g))), (int)(255.0 * (b > 1.0 ? 1.0 : (b < 0.0 ? 0.0 : b)))));
    }

    public void set(double r, double g, double b, double a) {
        this.set(new Color((int)(255.0 * (r > 1.0 ? 1.0 : (r < 0.0 ? 0.0 : r))), (int)(255.0 * (g > 1.0 ? 1.0 : (g < 0.0 ? 0.0 : g))), (int)(255.0 * (b > 1.0 ? 1.0 : (b < 0.0 ? 0.0 : b))), (int)(255.0 * (a > 1.0 ? 1.0 : (a < 0.0 ? 0.0 : a)))));
    }

    public void set(Color value) {
        this.value = value;
    }

    public static String generateParseableString(Color color) {
        return "createColor(" + (double)color.getRed() / 255.0 + "," + (double)color.getGreen() / 255.0 + "," + (double)color.getBlue() / 255.0 + (color.getAlpha() != 255 ? "," + (double)color.getAlpha() / 255.0 : "") + ")";
    }
}

