/*
 * Decompiled with CFR 0.152.
 */
package symbolTableFileUtilities;

import actionScript.ActionScriptFlags;
import expressionConsole.ExpressionConsoleModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import parser.RecursiveDescentParser;
import valueTypes.DecimalValue;
import variables.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTableStateUtilities {
    private SymbolTableStateUtilities() {
    }

    public static List<String> takeSymbolTableSnapshot() {
        ArrayList<Variable> variables = new ArrayList<Variable>(Variable.getSymbolTable().values());
        Collections.sort(variables, new Comparator<Variable>(){

            @Override
            public int compare(Variable a, Variable b) {
                return a.getTimeOfLastChange() > a.getTimeOfLastChange() ? 1 : -1;
            }
        });
        LinkedList<String> variableAssignmentExpressions = new LinkedList<String>();
        for (Variable current : variables) {
            variableAssignmentExpressions.add(String.valueOf(current.toString()) + "=" + current.evaluate().toParseableString());
        }
        return variableAssignmentExpressions;
    }

    public static void applySymbolTableSnapshot(List<String> newSymbolTable) {
        ActionScriptFlags.suppressWarningDialogBoxes = true;
        DecimalValue zeroValue = new DecimalValue(0.0);
        Iterator<Map.Entry<String, Variable>> it = Variable.getSymbolTable().entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().set(zeroValue);
        }
        RecursiveDescentParser parser = ExpressionConsoleModel.getInstance().getParser();
        Iterator<String> it2 = newSymbolTable.iterator();
        while (it2.hasNext()) {
            parser.parse(it2.next()).evaluate();
        }
        ActionScriptFlags.suppressWarningDialogBoxes = true;
    }
}

