/*
 * Decompiled with CFR 0.152.
 */
package symbolTableFileUtilities;

import fileUtilities.ExtentionFileFilter;
import fileUtilities.SaveUtility;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import symbolTableFileUtilities.SymbolTableStateUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTableFileUtilities {
    public static final String FILE_EXTENTION = "graph";

    public static void promptUserToSaveSymbolTable() {
        File f = SaveUtility.promptUserToSave(FILE_EXTENTION);
        if (f != null) {
            SymbolTableFileUtilities.saveSymbolTable(f);
        }
    }

    public static void saveSymbolTable(File outputFile) {
        List<String> symbolTableSnapshot = SymbolTableStateUtilities.takeSymbolTableSnapshot();
        try {
            XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(outputFile)));
            e.writeObject(symbolTableSnapshot);
            e.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error writing file.", "Error", 0);
        }
    }

    public static List<String> promptUserToLoadSymbolTable() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new ExtentionFileFilter("hist"));
        if (chooser.showOpenDialog(null) == 0) {
            return SymbolTableFileUtilities.loadSymbolTable(chooser.getSelectedFile());
        }
        return null;
    }

    public static List<String> loadSymbolTable(File inputFile) {
        List symbolTable = null;
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(inputFile)));
            symbolTable = (List)d.readObject();
            d.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error loading file.", "Error", 0);
        }
        return symbolTable;
    }

    public static void promptUserToloadAndApplySymbolTable() {
        List<String> newSymbolTable = SymbolTableFileUtilities.promptUserToLoadSymbolTable();
        if (newSymbolTable != null) {
            SymbolTableStateUtilities.applySymbolTableSnapshot(newSymbolTable);
        }
    }
}

