/*
 * Decompiled with CFR 0.152.
 */
package primitives3D;

public class Vector3D {
    public double x;
    public double y;
    public double z;
    private static double sint;
    private static double cost;
    private static double newX;
    private static double newY;
    private static double newZ;

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Vector3D vector) {
        this(vector.x, vector.y, vector.z);
    }

    public Vector3D() {
        this(0.0, 0.0, 0.0);
    }

    public void rotateVectorAboutXAxis(double theta, Vector3D vectorToPutResultsIn) {
        sint = Math.sin(theta);
        cost = Math.cos(theta);
        newX = this.x;
        newY = this.y * cost - this.z * sint;
        newZ = this.y * sint + this.z * cost;
        vectorToPutResultsIn.x = newX;
        vectorToPutResultsIn.y = newY;
        vectorToPutResultsIn.z = newZ;
    }

    public void rotateVectorAboutYAxis(double theta, Vector3D vectorToPutResultsIn) {
        sint = Math.sin(theta);
        cost = Math.cos(theta);
        newX = this.z * sint + this.x * cost;
        newY = this.y;
        newZ = this.z * cost - this.x * sint;
        vectorToPutResultsIn.x = newX;
        vectorToPutResultsIn.y = newY;
        vectorToPutResultsIn.z = newZ;
    }

    public void rotateVectorAboutZAxis(double theta, Vector3D vectorToPutResultsIn) {
        sint = Math.sin(theta);
        cost = Math.cos(theta);
        newX = this.x * cost - this.y * sint;
        newY = this.x * sint + this.y * cost;
        newZ = this.z;
        vectorToPutResultsIn.x = newX;
        vectorToPutResultsIn.y = newY;
        vectorToPutResultsIn.z = newZ;
    }

    public Vector3D plus(Vector3D b) {
        Vector3D results = new Vector3D(0.0, 0.0, 0.0);
        this.plus(b, results);
        return results;
    }

    public void plus(Vector3D b, Vector3D vectorToPutResultsIn) {
        vectorToPutResultsIn.x = this.x + b.x;
        vectorToPutResultsIn.y = this.y + b.y;
        vectorToPutResultsIn.z = this.z + b.z;
    }

    public Vector3D minus(Vector3D b) {
        Vector3D results = new Vector3D(0.0, 0.0, 0.0);
        this.minus(b, results);
        return results;
    }

    public void minus(Vector3D b, Vector3D vectorToPutResultsIn) {
        vectorToPutResultsIn.x = this.x - b.x;
        vectorToPutResultsIn.y = this.y - b.y;
        vectorToPutResultsIn.z = this.z - b.z;
    }

    public Vector3D cross(Vector3D b) {
        return this.cross(new Vector3D());
    }

    public void cross(Vector3D b, Vector3D vectorToPutResultsIn) {
        vectorToPutResultsIn.x = this.y * b.z - this.z * b.y;
        vectorToPutResultsIn.y = this.z * b.x - this.x * b.z;
        vectorToPutResultsIn.z = this.x * b.y - this.y * b.x;
    }

    public Vector3D times(double scalarFactor) {
        Vector3D results = new Vector3D();
        this.times(scalarFactor, results);
        return results;
    }

    public void times(double scalarFactor, Vector3D vectorToPutResultsIn) {
        vectorToPutResultsIn.x = this.x * scalarFactor;
        vectorToPutResultsIn.y = this.y * scalarFactor;
        vectorToPutResultsIn.z = this.z * scalarFactor;
    }

    public static void calculateNormal(Vector3D a, Vector3D b, Vector3D c, Vector3D vectorToPutNormalInto) {
        double Ax = a.x - b.x;
        double Ay = a.y - b.y;
        double Az = a.z - b.z;
        double Bx = c.x - b.x;
        double By = c.y - b.y;
        double Bz = c.z - b.z;
        vectorToPutNormalInto.x = Ay * Bz - Az * By;
        vectorToPutNormalInto.y = Az * Bx - Ax * Bz;
        vectorToPutNormalInto.z = Ax * By - Ay * Bx;
    }

    public static double calculateDistance(Vector3D a, Vector3D b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
    }

    public void set(Vector3D vectorToCopy) {
        this.x = vectorToCopy.x;
        this.y = vectorToCopy.y;
        this.z = vectorToCopy.z;
    }
}

