/*
 * Decompiled with CFR 0.152.
 */
package primitives3D;

import drawing3D.Object3DViewer;
import graphicsUtilities.Polygon2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import math3D.Window3D;
import primitives3D.LineSegment3D;
import primitives3D.Vector3D;

public class SolidRod3D
extends LineSegment3D {
    public static boolean drawAsSimpleLine = false;
    double thickness;
    Point2D.Float tempPoint = new Point2D.Float();
    Vector3D temp = new Vector3D(0.0, 0.0, 0.0);
    Polygon2D polygon = new Polygon2D(new float[4], new float[4], 4);

    public SolidRod3D(Vector3D p1, Vector3D p2, double thickness, Color color) {
        super(p1, p2, color);
        this.thickness = thickness;
    }

    public void calculateRotation(Window3D w) {
        if (drawAsSimpleLine) {
            super.calculateRotation(w);
        } else {
            w.getRotatedVector3D(this.p1, this.centerPoint);
            w.getPixelFromRotatedPoint3D(this.centerPoint, this.A);
            this.temp.x = this.centerPoint.x - this.thickness;
            this.temp.y = this.centerPoint.y;
            this.temp.z = this.centerPoint.z;
            w.getPixelFromRotatedPoint3D(this.temp, this.tempPoint);
            double p1Width = Math.abs(this.A.x - this.tempPoint.x);
            w.getRotatedVector3D(this.p2, this.centerPoint);
            w.getPixelFromRotatedPoint3D(this.centerPoint, this.B);
            this.temp.x = this.centerPoint.x - this.thickness;
            this.temp.y = this.centerPoint.y;
            this.temp.z = this.centerPoint.z;
            w.getPixelFromRotatedPoint3D(this.temp, this.tempPoint);
            double p2Width = Math.abs(this.B.x - this.tempPoint.x);
            double distance = Math.sqrt(Math.pow(this.B.x - this.A.x, 2.0) + Math.pow(this.B.y - this.A.y, 2.0));
            double unitX = -((double)(this.B.x - this.A.x)) / distance;
            double unitY = (double)(this.B.y - this.A.y) / distance;
            this.polygon.xpoints[0] = (float)((double)this.A.x + unitY * p1Width);
            this.polygon.xpoints[1] = (float)((double)this.B.x + unitY * p2Width);
            this.polygon.xpoints[2] = (float)((double)this.B.x - unitY * p2Width);
            this.polygon.xpoints[3] = (float)((double)this.A.x - unitY * p1Width);
            this.polygon.ypoints[0] = (float)((double)this.A.y + unitX * p1Width);
            this.polygon.ypoints[1] = (float)((double)this.B.y + unitX * p2Width);
            this.polygon.ypoints[2] = (float)((double)this.B.y - unitX * p2Width);
            this.polygon.ypoints[3] = (float)((double)this.A.y - unitX * p1Width);
        }
    }

    public void drawOnThis(Graphics2D g) {
        if (drawAsSimpleLine) {
            super.drawOnThis(g);
        } else if (this.A.x != -2.1474836E9f && this.B.x != -2.1474836E9f) {
            g.setColor(Object3DViewer.shadeColor(this.color, this.centerPoint.z));
            g.fill(this.polygon);
        }
    }
}

