/*
 * Decompiled with CFR 0.152.
 */
package primitives3D;

import graphicsUtilities.Polygon2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import math3D.Window3D;
import primitives3D.Object3D;
import primitives3D.Vector3D;

public class Polygon3D
extends Object3D {
    public static boolean shade = true;
    Vector3D normal = new Vector3D(0.0, 0.0, 0.0);
    Vector3D rotatedNormal = new Vector3D(0.0, 0.0, 0.0);
    Vector3D[] polygonPoints;
    float[] xPoints;
    float[] yPoints;
    Polygon2D polygon = new Polygon2D();
    Point2D.Float tempPoint = new Point2D.Float();
    Color shadedColor;
    int[] initColorComponents = new int[3];
    int[] colorComponents = new int[3];

    public Polygon3D(Vector3D[] polygonPoints, Color color) {
        if (polygonPoints.length < 3) {
            new Exception("polygonPoints must have at least 3 points to make a polygon!").printStackTrace();
        }
        this.polygonPoints = polygonPoints;
        this.xPoints = new float[polygonPoints.length];
        this.yPoints = new float[polygonPoints.length];
        int i = 0;
        while (i < polygonPoints.length) {
            this.xPoints[i] = 0.0f;
            this.yPoints[i] = 0.0f;
            ++i;
        }
        this.polygon.xpoints = this.xPoints;
        this.polygon.ypoints = this.yPoints;
        this.polygon.npoints = polygonPoints.length;
        this.color = color;
        this.shadedColor = color;
    }

    public void drawOnThis(Graphics2D g) {
        g.setColor(shade ? this.shadedColor : this.color);
        g.fill(this.polygon);
    }

    public void calculateRotation(Window3D w) {
        w.getRotatedVector3D(this.polygonPoints[0], this.centerPoint);
        w.getPixelFromRotatedPoint3D(this.centerPoint, this.tempPoint);
        this.xPoints[0] = this.tempPoint.x;
        this.yPoints[0] = this.tempPoint.y;
        int i = 1;
        while (i < this.polygonPoints.length) {
            w.getPixelFromVector3D(this.polygonPoints[i], this.tempPoint);
            this.xPoints[i] = this.tempPoint.x;
            this.yPoints[i] = this.tempPoint.y;
            ++i;
        }
        if (w.drawFor3D) {
            if (shade) {
                this.calculateShading(w);
            }
        } else {
            this.shadedColor = this.color;
        }
    }

    private void calculateShading(Window3D w) {
        Vector3D.calculateNormal(this.polygonPoints[0], this.polygonPoints[1], this.polygonPoints[2], this.normal);
        w.getRotatedVector3D(this.normal, this.rotatedNormal);
        double thetaX = Math.atan2(this.rotatedNormal.x, this.rotatedNormal.z);
        double thetaY = Math.atan2(this.rotatedNormal.y, this.rotatedNormal.z);
        double sunX = 0.0;
        double sunY = 0.0;
        double angleAwayFromSunX = Math.abs(thetaX - sunX);
        double angleAwayFromSunY = Math.abs(thetaY - sunY);
        double AngleAwayFromSun = Math.sqrt(angleAwayFromSunX * angleAwayFromSunX + angleAwayFromSunY * angleAwayFromSunY);
        double maxAngleAwayFromSun = Math.sqrt(2.0) * Math.PI;
        double scaledAngleAwayFromSun = 1.0 - AngleAwayFromSun / maxAngleAwayFromSun;
        double usableAngleAwayFromSun = 2.0 * Math.abs(scaledAngleAwayFromSun - 0.5);
        this.initColorComponents[0] = this.color.getRed();
        this.initColorComponents[1] = this.color.getGreen();
        this.initColorComponents[2] = this.color.getBlue();
        int i = 0;
        while (i < 3) {
            this.colorComponents[i] = (int)((double)this.initColorComponents[i] * (usableAngleAwayFromSun + 0.2));
            if (this.colorComponents[i] > 255) {
                this.colorComponents[i] = 255;
            }
            if (this.colorComponents[i] < 0) {
                this.colorComponents[i] = 0;
            }
            ++i;
        }
        this.shadedColor = new Color(this.colorComponents[0], this.colorComponents[1], this.colorComponents[2], this.color.getAlpha());
    }
}

