/*
 * Decompiled with CFR 0.152.
 */
package primitives3D;

import drawing3D.Object3DViewer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import math3D.Window3D;
import primitives3D.Object3D;
import primitives3D.Vector3D;

public class Ball3D
extends Object3D {
    protected Color color;
    public Vector3D p;
    public boolean shade = true;
    double radius;
    Vector3D temp = new Vector3D(0.0, 0.0, 0.0);
    Point A = new Point();
    Point B = new Point();

    public Ball3D(Vector3D p, double radius, Color color) {
        this.p = p;
        this.radius = radius;
        this.color = color;
    }

    public void drawOnThis(Graphics2D g) {
        if (this.A.x != Integer.MIN_VALUE && this.B.x != Integer.MIN_VALUE) {
            if (this.shade) {
                g.setColor(Object3DViewer.shadeColor(this.color, this.centerPoint.z));
            } else {
                g.setColor(this.color);
            }
            g.fillOval(this.A.x, this.A.y, this.B.x, this.B.y);
        }
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void calculateRotation(Window3D w) {
        w.getRotatedVector3D(this.p, this.centerPoint);
        w.getPixelFromRotatedPoint3D(this.centerPoint, this.A);
        this.temp.x = this.centerPoint.x - this.radius;
        this.temp.y = this.centerPoint.y;
        this.temp.z = this.centerPoint.z;
        w.getPixelFromRotatedPoint3D(this.temp, this.B);
        int d = Math.abs(this.B.x - this.A.x);
        this.A.x -= d / 2;
        this.A.y -= d / 2;
        this.B.x = d;
        this.B.y = d;
    }

    public boolean contains(Point point) {
        return new Rectangle(this.A.x, this.A.y, this.B.x, this.B.y).contains(point);
    }

    public void setCenterPoint(Vector3D point) {
        this.p.set(point);
    }
}

