/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.HashMap;
import java.util.Map;
import operators.BinaryOperatorCreator;
import operators.Factorial;
import operators.Minus;
import operators.Operators;
import operators.UnaryOperator;
import operators.UnaryOperatorCreator;
import parser.ExpressionList;
import parser.ExpressionNode;
import parser.TokenScanner;
import parser.Value;
import valueTypes.ErrorValue;
import valueTypes.FunctionValue;
import variables.Constants;
import variables.Variable;

public class RecursiveDescentParser {
    Map<String, BinaryOperatorCreator> binaryOperators = new HashMap<String, BinaryOperatorCreator>();
    Map<String, UnaryOperatorCreator> unaryOperators = new HashMap<String, UnaryOperatorCreator>();
    Object token;
    UnaryOperator lastParsedUnaryOperator;
    TokenScanner tokenScanner;

    public RecursiveDescentParser() {
        Constants.initializeConstants();
        Operators.getBinaryOperators(this);
        Operators.getUnaryOperators(this);
    }

    public ExpressionNode parse(String expression) {
        this.tokenScanner = new TokenScanner(this.binaryOperators, this.unaryOperators, expression);
        this.lastParsedUnaryOperator = null;
        this.token = this.tokenScanner.scan();
        return this.expression();
    }

    private ExpressionNode expression() {
        return this.expression(-6);
    }

    private ExpressionNode expression(int precedence) {
        ExpressionNode root;
        ExpressionNode expressionNode = root = ++precedence == 4 ? this.factor() : this.expression(precedence);
        while (this.token instanceof BinaryOperatorCreator && ((BinaryOperatorCreator)this.token).precedence == precedence) {
            BinaryOperatorCreator binaryOperatorCreator = (BinaryOperatorCreator)this.token;
            this.token = this.tokenScanner.scan();
            root = binaryOperatorCreator.create(root, precedence == 4 ? this.factor() : this.expression(precedence));
        }
        if (this.token instanceof ErrorValue) {
            return (ErrorValue)this.token;
        }
        if (this.token instanceof Character && ((Character)this.token).charValue() == '!') {
            this.token = this.tokenScanner.scan();
            return new Factorial(root);
        }
        if (this.token instanceof Character && ((Character)this.token).charValue() == '{') {
            UnaryOperator previouslyParsedUnaryOperator = this.lastParsedUnaryOperator;
            FunctionValue associatedFunction = new FunctionValue(this.parseGrouping('}'));
            if (previouslyParsedUnaryOperator == null) {
                return new ErrorValue("no operator present to associate the function " + associatedFunction + " with");
            }
            if (previouslyParsedUnaryOperator.linkAssociatedFunction(associatedFunction)) {
                return root;
            }
            return new ErrorValue("the function " + associatedFunction + " cannot be associated with an operator which does not accept associated functions.");
        }
        return root;
    }

    private ExpressionNode factor() {
        ExpressionNode root = null;
        if (this.token instanceof Value) {
            root = (Value)this.token;
            this.token = this.tokenScanner.scan();
            return root;
        }
        if (this.token instanceof UnaryOperatorCreator) {
            UnaryOperatorCreator unopCreator = (UnaryOperatorCreator)this.token;
            this.token = this.tokenScanner.scan();
            ExpressionNode child = this.factor();
            this.lastParsedUnaryOperator = unopCreator.create(child);
            return this.lastParsedUnaryOperator;
        }
        if (this.token instanceof Minus) {
            this.token = this.tokenScanner.scan();
            return Minus.createUnaryMinus(this.factor());
        }
        if (this.token instanceof Character) {
            char c = ((Character)this.token).charValue();
            switch (c) {
                case '(': {
                    return this.parseGrouping(')');
                }
                case '[': {
                    return ExpressionList.extractExpressionList(this.parseGrouping(']'));
                }
                case '{': {
                    return new FunctionValue(this.parseGrouping('}'));
                }
            }
            return new ErrorValue("invalid character: " + c);
        }
        if (this.token instanceof Variable) {
            root = (Variable)this.token;
            this.token = this.tokenScanner.scan();
            return root;
        }
        return new ErrorValue("Syntax error: '" + this.token + "'");
    }

    private ExpressionNode parseGrouping(char endGroupingChar) {
        this.token = this.tokenScanner.scan();
        ExpressionNode root = this.expression();
        if (!(this.token instanceof Character) || ((Character)this.token).charValue() != endGroupingChar) {
            return new ErrorValue("missing '" + endGroupingChar + "' at " + this.token);
        }
        this.token = this.tokenScanner.scan();
        return root;
    }

    public void addBinaryOperator(String symbol, BinaryOperatorCreator creator) {
        this.binaryOperators.put(symbol, creator);
    }

    public void addUnaryOperator(String name, UnaryOperatorCreator creator) {
        this.unaryOperators.put(name, creator);
    }
}

