/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import operators.BinaryOperatorCreator;
import operators.UnaryOperatorCreator;
import parser.RecursiveDescentParser;
import variables.Constant;
import variables.Variable;

public class ParserUtilities {
    public static String getObservedVariablesAndDescriptions() {
        Variable currentVariable;
        StringBuffer variablesStringBuffer = new StringBuffer();
        Map<String, Variable> symbolTable = Variable.getSymbolTable();
        LinkedList<Variable> variables = new LinkedList<Variable>();
        Iterator<Map.Entry<String, Variable>> it = symbolTable.entrySet().iterator();
        while (it.hasNext()) {
            currentVariable = it.next().getValue();
            if (!currentVariable.hasObservers()) continue;
            variables.add(currentVariable);
        }
        it = variables.iterator();
        while (it.hasNext()) {
            currentVariable = (Variable)((Object)it.next());
            variablesStringBuffer.append(String.valueOf(currentVariable.toString()) + "\t- ");
            Iterator<String> i = currentVariable.getObserverExplainations().iterator();
            while (i.hasNext()) {
                variablesStringBuffer.append(String.valueOf(i.next()) + " ");
            }
            if (!it.hasNext()) continue;
            variablesStringBuffer.append("\n");
        }
        return variablesStringBuffer.toString();
    }

    public static String getConstantsAndDescriptions() {
        StringBuffer variablesStringBuffer = new StringBuffer();
        Map<String, Variable> symbolTable = Variable.getSymbolTable();
        LinkedList<Constant> variables = new LinkedList<Constant>();
        Iterator<Map.Entry<String, Variable>> it = symbolTable.entrySet().iterator();
        while (it.hasNext()) {
            Variable currentVariable = it.next().getValue();
            if (!(currentVariable instanceof Constant)) continue;
            variables.add((Constant)currentVariable);
        }
        it = variables.iterator();
        while (it.hasNext()) {
            Constant currentConstant = (Constant)((Object)it.next());
            variablesStringBuffer.append(String.valueOf(currentConstant.toString()) + "\t- " + currentConstant.getDescription() + (it.hasNext() ? "\n" : ""));
        }
        return variablesStringBuffer.toString();
    }

    public static String getUnopsAndDescriptions(RecursiveDescentParser parserToExtractFrom, int type) {
        StringBuffer stringBuffer = new StringBuffer();
        Map<String, UnaryOperatorCreator> allUnops = parserToExtractFrom.unaryOperators;
        LinkedList<Map.Entry<String, UnaryOperatorCreator>> unops = new LinkedList<Map.Entry<String, UnaryOperatorCreator>>();
        for (Map.Entry<String, UnaryOperatorCreator> currentEntry : allUnops.entrySet()) {
            if (currentEntry.getValue().getType() != type) continue;
            unops.add(currentEntry);
        }
        Iterator<Map.Entry<String, UnaryOperatorCreator>> it = unops.iterator();
        while (it.hasNext()) {
            Map.Entry<String, UnaryOperatorCreator> currentEntry;
            currentEntry = it.next();
            stringBuffer.append(String.valueOf(currentEntry.getKey()) + "()\t- " + currentEntry.getValue().getDescription() + (it.hasNext() ? "\n" : ""));
        }
        return stringBuffer.toString();
    }

    public static String getBinopsAndDescriptions(RecursiveDescentParser parserToExtractFrom) {
        StringBuffer stringBuffer = new StringBuffer();
        Map<String, BinaryOperatorCreator> allBinops = parserToExtractFrom.binaryOperators;
        Iterator<Map.Entry<String, BinaryOperatorCreator>> it = allBinops.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, BinaryOperatorCreator> currentEntry = it.next();
            BinaryOperatorCreator currentBinop = currentEntry.getValue();
            stringBuffer.append(String.valueOf(currentEntry.getKey()) + "\t- " + currentBinop.getDescription() + (it.hasNext() ? "\n" : ""));
        }
        return stringBuffer.toString();
    }
}

