/*
 * Decompiled with CFR 0.152.
 */
package parser;

import parser.ExpressionNode;
import parser.Value;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ErrorValue;

public class ExpressionList
extends Value {
    ExpressionNode[] nodes;

    private ExpressionList(ExpressionNode[] nodes) {
        this.nodes = nodes;
    }

    public static Value extractExpressionList(ExpressionNode node) {
        if (node instanceof CharacterSeparatedStatementPair) {
            CharacterSeparatedStatementPair listOfExpressions = (CharacterSeparatedStatementPair)node;
            if (listOfExpressions.getSymbol().equals(",")) {
                ExpressionNode[] allExpressions = ((CharacterSeparatedStatementPair)node).extractAllStatements();
                if (allExpressions.length == 1 && allExpressions[0] instanceof ErrorValue) {
                    return (ErrorValue)allExpressions[0];
                }
                return new ExpressionList(allExpressions);
            }
            return new ErrorValue("The symbol \"" + listOfExpressions.getSymbol() + "\" is an invalid element separator when creating a list");
        }
        ExpressionNode[] allExpressions = new ExpressionNode[]{node};
        return new ExpressionList(allExpressions);
    }

    public ExpressionNode[] getNodes() {
        return this.nodes;
    }

    public String getType() {
        return "List of expressions";
    }

    public String toString() {
        return this.toParseableString();
    }

    public String toParseableString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[");
        int i = 0;
        while (i < this.nodes.length) {
            buff.append(String.valueOf(this.nodes[i].toString()) + (i < this.nodes.length - 1 ? ", " : ""));
            ++i;
        }
        buff.append("]");
        return buff.toString();
    }
}

