/*
 * Decompiled with CFR 0.152.
 */
package operators;

import java.util.HashMap;
import java.util.Map;
import operators.BinaryOperator;
import operators.BinaryOperatorCreator;
import operators.ForLoop;
import operators.MathematicalUnaryOperatorCreator;
import operators.Minus;
import operators.RealNumberBinaryOperator;
import operators.RealNumberUnaryOperator;
import operators.UnaryOperator;
import operators.UnaryOperatorCreator;
import parser.ExpressionNode;
import parser.RecursiveDescentParser;
import parser.Value;
import valueTypes.BooleanValue;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ColorValue;
import valueTypes.DecimalValue;
import valueTypes.ErrorValue;
import valueTypes.FunctionValue;
import valueTypes.IntegerValue;
import valueTypes.NullValue;
import valueTypes.StringValue;
import variables.Variable;

public class Operators {
    private static Map<String, BinaryOperatorCreator> binaryOperators = null;
    private static Map<String, UnaryOperatorCreator> unaryOperators = null;

    public static void getBinaryOperators(RecursiveDescentParser parent) {
        Operators.createAllBinaryOperators();
        for (Map.Entry<String, BinaryOperatorCreator> entry : binaryOperators.entrySet()) {
            parent.addBinaryOperator(entry.getKey(), entry.getValue());
        }
    }

    private static void createAllBinaryOperators() {
        if (binaryOperators == null) {
            binaryOperators = new HashMap<String, BinaryOperatorCreator>();
            binaryOperators.put("+", new BinaryOperatorCreator(1){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator('+', left, right){

                        double evaluate(double l, double r) {
                            return l + r;
                        }
                    };
                }

                public String getDescription() {
                    return "plus, the addition operator";
                }
            });
            binaryOperators.put("-", new Minus());
            binaryOperators.put("*", new BinaryOperatorCreator(2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator('*', left, right){

                        double evaluate(double l, double r) {
                            return l * r;
                        }
                    };
                }

                public String getDescription() {
                    return "times, the multiplication operator";
                }
            });
            binaryOperators.put("/", new BinaryOperatorCreator(2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator('/', left, right){

                        double evaluate(double l, double r) {
                            return l / r;
                        }
                    };
                }

                public String getDescription() {
                    return "divide by, the division operator";
                }
            });
            binaryOperators.put("%", new BinaryOperatorCreator(2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator('%', left, right){

                        double evaluate(double l, double r) {
                            return l % r;
                        }
                    };
                }

                public String getDescription() {
                    return "modulo, calculates the remainder. For example, 10%7 is read \"ten mod (or modulo) seven\" and results in 3. The % operator is not restricted to integers.";
                }
            });
            binaryOperators.put("^", new BinaryOperatorCreator(3){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator('^', left, right){

                        double evaluate(double l, double r) {
                            return Math.pow(l, r);
                        }
                    };
                }

                public String getDescription() {
                    return "a^b = a to the power of b.";
                }
            });
            binaryOperators.put("E", new BinaryOperatorCreator(4){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new RealNumberBinaryOperator('E', left, right){

                        double evaluate(double l, double r) {
                            return l * Math.pow(10.0, r);
                        }
                    };
                }

                public String getDescription() {
                    return "times 10 to the power of... (a)E(b) = a*(10^b). For example, 5E2 = 500";
                }
            });
            binaryOperators.put("<", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("<", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) < 0;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }

                public String getDescription() {
                    return "the \"less than\" comparison. a<b yields true if a is less than b, false otherwise";
                }
            });
            binaryOperators.put("<=", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("<=", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) < 1;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }

                public String getDescription() {
                    return "the \"less than or equal to\" comparison. a<=b yields true if a is less than or equal to b, false otherwise";
                }
            });
            binaryOperators.put(">", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(">", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) > 0;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }

                public String getDescription() {
                    return "the \"greater than\" comparison. a>b yields true if a is greater than b, false otherwise";
                }
            });
            binaryOperators.put(">=", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator(">=", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            if (leftResult instanceof Comparable && rightResult instanceof Comparable) {
                                try {
                                    this.persistantResult.value = ((Comparable)((Object)leftResult)).compareTo(rightResult) > -1;
                                    return this.persistantResult;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            return new ErrorValue(leftResult + " and " + rightResult + " cannot be compared");
                        }
                    };
                }

                public String getDescription() {
                    return "the \"greater than or equal to\" comparison. a>=b yields true if a is greater than or equal to b, false otherwise";
                }
            });
            binaryOperators.put("==", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("==", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            this.persistantResult.value = leftResult.equals(rightResult);
                            return this.persistantResult;
                        }
                    };
                }

                public String getDescription() {
                    return "the \"equal to\" comparison. a==b yields true if a is equal to b, false otherwise";
                }
            });
            binaryOperators.put("!=", new BinaryOperatorCreator(0){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("!=", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value rightResult;
                            Value leftResult = this.leftChild.evaluate();
                            this.persistantResult.value = !leftResult.equals(rightResult = this.rightChild.evaluate());
                            return this.persistantResult;
                        }
                    };
                }

                public String getDescription() {
                    return "the \"not equal to\" comparison. a!=b yields true if a is not equal to b, false otherwise";
                }
            });
            binaryOperators.put("&&", new BinaryOperatorCreator(-1){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("&&", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            try {
                                this.persistantResult.value = ((BooleanValue)leftResult).value && ((BooleanValue)rightResult).value;
                                return this.persistantResult;
                            }
                            catch (Exception e) {
                                return new ErrorValue("&& is not a valid operator for " + leftResult + " and " + rightResult);
                            }
                        }
                    };
                }

                public String getDescription() {
                    return "the boolean AND operation, only works with two booleans.";
                }
            });
            binaryOperators.put("||", new BinaryOperatorCreator(-1){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("||", left, right){
                        BooleanValue persistantResult;
                        {
                            this.persistantResult = new BooleanValue(false);
                        }

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            Value rightResult = this.rightChild.evaluate();
                            try {
                                this.persistantResult.value = ((BooleanValue)leftResult).value || ((BooleanValue)rightResult).value;
                                return this.persistantResult;
                            }
                            catch (Exception e) {
                                return new ErrorValue("|| is not a valid operator for " + leftResult + " and " + rightResult);
                            }
                        }
                    };
                }

                public String getDescription() {
                    return "the boolean OR operation, only works with two booleans.";
                }
            });
            binaryOperators.put("?", new BinaryOperatorCreator(-3){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("?", left, right){

                        public Value evaluate() {
                            Value leftResult = this.leftChild.evaluate();
                            if (leftResult instanceof BooleanValue) {
                                if (this.rightChild instanceof CharacterSeparatedStatementPair && ((CharacterSeparatedStatementPair)this.rightChild).getSymbol().equals(":")) {
                                    if (((BooleanValue)leftResult).value) {
                                        return ((CharacterSeparatedStatementPair)this.rightChild).getLeftStatement().evaluate();
                                    }
                                    return ((CharacterSeparatedStatementPair)this.rightChild).getRightStatement().evaluate();
                                }
                                return new ErrorValue(this.rightChild + " should be a colon separated statement pair for the ? : operator");
                            }
                            return new ErrorValue(leftResult + " is an invalid condition for the ? : operator");
                        }
                    };
                }

                public String getDescription() {
                    return "the \"?\" part of the ?: ternary operator. \"a<b?c=2:c=3\" executes \"c=2\" if a is less than b, or executes \"c=3\" otherwise.";
                }
            });
            binaryOperators.put(":", new BinaryOperatorCreator(-2){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new CharacterSeparatedStatementPair(":", left, right);
                }

                public String getDescription() {
                    return "the \":\" part of the ?: ternary operator. \"a<b?c=2:c=3\" executes \"c=2\" if a is less than b, or executes \"c=3\" otherwise.";
                }
            });
            binaryOperators.put(";", new BinaryOperatorCreator(-5){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new CharacterSeparatedStatementPair(";", left, right);
                }

                public String getDescription() {
                    return "a statement separator";
                }
            });
            binaryOperators.put(",", new BinaryOperatorCreator(-5){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new CharacterSeparatedStatementPair(",", left, right);
                }

                public String getDescription() {
                    return "an argument separator";
                }
            });
            binaryOperators.put("=", new BinaryOperatorCreator(-4){

                public BinaryOperator create(ExpressionNode left, ExpressionNode right) {
                    return new BinaryOperator("=", left, right){

                        public Value evaluate() {
                            Value rightValue = this.rightChild.evaluate();
                            try {
                                return ((Variable)this.leftChild).set(rightValue);
                            }
                            catch (Exception e) {
                                Value leftValue = this.leftChild.evaluate();
                                return new ErrorValue("'=' is not a valid operator for the types " + leftValue.getType() + " and " + rightValue.getType() + ", so " + leftValue + " = " + rightValue + " could not be evaluated");
                            }
                        }
                    };
                }

                public String getDescription() {
                    return "the assignment operator. Takes a variable name on the left, and a value on the right. For example, \"a=5\" changes the value of a to 5";
                }
            });
        }
    }

    public static void getUnaryOperators(RecursiveDescentParser parent) {
        Operators.createAllUnaryOperators();
        for (Map.Entry<String, UnaryOperatorCreator> entry : unaryOperators.entrySet()) {
            parent.addUnaryOperator(entry.getKey(), entry.getValue());
        }
    }

    private static void createAllUnaryOperators() {
        if (unaryOperators == null) {
            unaryOperators = new HashMap<String, UnaryOperatorCreator>();
            unaryOperators.put("sin", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("sin", child){

                        double evaluate(double x) {
                            return Math.sin(x);
                        }
                    };
                }

                public String getDescription() {
                    return "the sine function";
                }
            });
            unaryOperators.put("cos", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("cos", child){

                        double evaluate(double x) {
                            return Math.cos(x);
                        }
                    };
                }

                public String getDescription() {
                    return "the cosine function";
                }
            });
            unaryOperators.put("tan", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("tan", child){

                        double evaluate(double x) {
                            return Math.tan(x);
                        }
                    };
                }

                public String getDescription() {
                    return "the tangent function, tan(x) = sin(x)/cos(x)";
                }
            });
            unaryOperators.put("asin", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("asin", child){

                        double evaluate(double x) {
                            return Math.asin(x);
                        }
                    };
                }

                public String getDescription() {
                    return "arcSine, the inverse of the sine function";
                }
            });
            unaryOperators.put("acos", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("acos", child){

                        double evaluate(double x) {
                            return Math.acos(x);
                        }
                    };
                }

                public String getDescription() {
                    return "arcCosine, the inverse of the cosine function";
                }
            });
            unaryOperators.put("atan", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("atan", child){

                        double evaluate(double x) {
                            return Math.atan(x);
                        }
                    };
                }

                public String getDescription() {
                    return "arcTangent, the inverse of the tangent function";
                }
            });
            unaryOperators.put("cot", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("cot", child){
                        double HALF_PI;
                        {
                            this.HALF_PI = 1.5707963267948966;
                        }

                        double evaluate(double x) {
                            return Math.tan(this.HALF_PI - x);
                        }
                    };
                }

                public String getDescription() {
                    return "the cotangent function, cot(x) = cos(x)/sin(x)";
                }
            });
            unaryOperators.put("sec", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("sec", child){

                        double evaluate(double x) {
                            return 1.0 / Math.cos(x);
                        }
                    };
                }

                public String getDescription() {
                    return "the secant function, sec(x) = 1/cos(x)";
                }
            });
            unaryOperators.put("csc", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("csc", child){

                        double evaluate(double x) {
                            return 1.0 / Math.sin(x);
                        }
                    };
                }

                public String getDescription() {
                    return "the cosecant function, csc(x) = 1/sin(x)";
                }
            });
            unaryOperators.put("ln", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("ln", child){

                        double evaluate(double x) {
                            return Math.log(x);
                        }
                    };
                }

                public String getDescription() {
                    return "natural logarithm, log base e";
                }
            });
            unaryOperators.put("log", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("ln", child){
                        double conversion;
                        {
                            this.conversion = Math.log(10.0);
                        }

                        double evaluate(double x) {
                            return (float)(Math.log(x) / this.conversion);
                        }
                    };
                }

                public String getDescription() {
                    return "logarithm base 10";
                }
            });
            unaryOperators.put("abs", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("abs", child){

                        double evaluate(double x) {
                            return Math.abs(x);
                        }
                    };
                }

                public String getDescription() {
                    return "absolute value";
                }
            });
            unaryOperators.put("sqrt", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("sqrt", child){

                        double evaluate(double x) {
                            return Math.sqrt(x);
                        }
                    };
                }

                public String getDescription() {
                    return "square root";
                }
            });
            unaryOperators.put("round", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("round", child){

                        double evaluate(double x) {
                            return Math.round(x);
                        }
                    };
                }

                public String getDescription() {
                    return "round to the nearest whole number";
                }
            });
            unaryOperators.put("floor", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("floor", child){

                        double evaluate(double x) {
                            return Math.floor(x);
                        }
                    };
                }

                public String getDescription() {
                    return "floor: floor(3.3) = 3, floor(3.9) = 3";
                }
            });
            unaryOperators.put("ceil", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new RealNumberUnaryOperator("ceil", child){

                        double evaluate(double x) {
                            return Math.ceil(x);
                        }
                    };
                }

                public String getDescription() {
                    return "ceiling: ceil(3.3) = 4, ceil(3.9) = 4";
                }
            });
            unaryOperators.put("createFunction", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){

                        public Value evaluate() {
                            return new FunctionValue(this.child);
                        }

                        public String toString() {
                            return "createFunction(" + this.child + ")";
                        }
                    };
                }

                public String getDescription() {
                    return "creates a function, which can be evaluated by the executeFunction() operator";
                }

                public int getType() {
                    return 2;
                }
            });
            unaryOperators.put("executeFunction", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){

                        public Value evaluate() {
                            Value value = this.child.evaluate();
                            if (value instanceof FunctionValue) {
                                return ((FunctionValue)value).executeFunction();
                            }
                            return new ErrorValue("executeFunction only takes a FunctionValue as an argument, not a " + value.getType() + "; " + value.toString());
                        }

                        public String toString() {
                            return "executeFunction(" + this.child + ")";
                        }
                    };
                }

                public String getDescription() {
                    return "executes a function, which can be created by the createFunction() operator";
                }

                public int getType() {
                    return 2;
                }
            });
            unaryOperators.put("if", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){
                        FunctionValue associatedFunction;
                        {
                            this.associatedFunction = null;
                        }

                        public Value evaluate() {
                            Value condition = this.child.evaluate();
                            if (condition instanceof BooleanValue) {
                                if (((BooleanValue)condition).value) {
                                    if (this.associatedFunction != null) {
                                        this.associatedFunction.executeFunction();
                                        return NullValue.NULL;
                                    }
                                    return new ErrorValue("no associated function for \"if\" statement!");
                                }
                                return NullValue.NULL;
                            }
                            return new ErrorValue("the value " + condition + " is not a BooleanValue, so it is an invalid condition for an \"if\" statement");
                        }

                        public String toString() {
                            return "if(" + this.child + ")";
                        }

                        public boolean linkAssociatedFunction(FunctionValue associatedFunction) {
                            this.associatedFunction = associatedFunction;
                            return true;
                        }
                    };
                }

                public String getDescription() {
                    return "the \"if\" construct, which executes an associated function if the argument is true. For example, when \"if(a<b){c = 5}\" is executed, c will be set to 5 if a is less than b";
                }

                public int getType() {
                    return 2;
                }
            });
            unaryOperators.put("while", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){
                        FunctionValue associatedFunction;
                        {
                            this.associatedFunction = null;
                        }

                        public Value evaluate() {
                            Value condition = this.child.evaluate();
                            if (condition instanceof BooleanValue) {
                                if (((BooleanValue)condition).value) {
                                    if (this.associatedFunction != null) {
                                        boolean conditionBoolean = true;
                                        try {
                                            while (conditionBoolean) {
                                                this.associatedFunction.executeFunction();
                                                conditionBoolean = ((BooleanValue)this.child.evaluate()).value;
                                            }
                                        }
                                        catch (Exception e) {
                                            return new ErrorValue("error occured in evaluating the condition " + this.child);
                                        }
                                        return NullValue.NULL;
                                    }
                                    return new ErrorValue("no associated function for \"while\" statement!");
                                }
                                return NullValue.NULL;
                            }
                            return new ErrorValue("the value " + condition + " is not a BooleanValue, so it is an invalid condition for a \"while\" statement");
                        }

                        public String toString() {
                            return "while(" + this.child + ")" + this.associatedFunction;
                        }

                        public boolean linkAssociatedFunction(FunctionValue associatedFunction) {
                            this.associatedFunction = associatedFunction;
                            return true;
                        }
                    };
                }

                public String getDescription() {
                    return "the \"while\" loop construct, which executes an associated function as long as the argument is true. For example, when \"{while(b < 100){b = b+1}\" is executed, the function \"b = b+1\" will be executed as many times as it takes for \"b < 100\" to be false, so after the execution of the while loop is finished, b will be 100";
                }

                public int getType() {
                    return 2;
                }
            });
            unaryOperators.put("for", new MathematicalUnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new ForLoop(child);
                }

                public String getDescription() {
                    return "the \"for\" loop construct, of the form \"for(initialisation;condition;after){statement(s)}\", which executes an associated function as long as the condition is true.";
                }

                public int getType() {
                    return 2;
                }
            });
            unaryOperators.put("createErrorValue", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){

                        public Value evaluate() {
                            Value value = this.child.evaluate();
                            if (value instanceof StringValue) {
                                return new ErrorValue(((StringValue)value).toString());
                            }
                            return new ErrorValue("createErrorValue() takes a string as an argument, " + value + " is an invalid argument.");
                        }
                    };
                }

                public String getDescription() {
                    return "creates an ErrorValue with the specified message. for example, \"createErrorValue(\"this error is because of ...\")";
                }

                public int getType() {
                    return 4;
                }
            });
            unaryOperators.put("createColor", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){
                        ColorValue reUsableValue;
                        {
                            this.reUsableValue = new ColorValue(0.5, 0.5, 0.5);
                        }

                        public Value evaluate() {
                            if (this.child instanceof CharacterSeparatedStatementPair) {
                                CharacterSeparatedStatementPair listOfVariables = (CharacterSeparatedStatementPair)this.child;
                                if (listOfVariables.getSymbol().equals(",")) {
                                    ExpressionNode[] statements = ((CharacterSeparatedStatementPair)this.child).extractAllStatements();
                                    if (statements.length == 3 || statements.length == 4) {
                                        double[] rgbValues = new double[statements.length];
                                        int i = 0;
                                        while (i < statements.length) {
                                            Value currentValue = statements[i].evaluate();
                                            if (!(currentValue instanceof DecimalValue)) {
                                                return new ErrorValue("createColor(redBetweenZeroAndOne,greenBetweenZeroAndOne,blueBetweenZeroAndOne" + (statements.length == 4 ? "opacityBetweenZeroAndOne" : "") + ") takes " + statements.length + " numbers as arguments. The type of argument number " + (1 + i) + " is " + currentValue.getType() + ", and is therefore not a valid argument.");
                                            }
                                            rgbValues[i] = ((DecimalValue)currentValue).value;
                                            ++i;
                                        }
                                        if (statements.length == 3) {
                                            this.reUsableValue.set(rgbValues[0], rgbValues[1], rgbValues[2]);
                                        } else {
                                            this.reUsableValue.set(rgbValues[0], rgbValues[1], rgbValues[2], rgbValues[3]);
                                        }
                                        return this.reUsableValue;
                                    }
                                    return new ErrorValue("createColor(redBetweenZeroAndOne,greenBetweenZeroAndOne,blueBetweenZeroAndOne,opacityBetweenZeroAndOne) takes 3 or 4, not" + statements.length + ", numbers as arguments.");
                                }
                                return new ErrorValue("createColor(redBetweenZeroAndOne,greenBetweenZeroAndOne,blueBetweenZeroAndOne,opacityBetweenZeroAndOne) takes 3 or 4 numbers separated by commas \",\" as arguments." + listOfVariables.getSymbol() + " is an invalid argument separator.");
                            }
                            return new ErrorValue("createColor(redBetweenZeroAndOne,greenBetweenZeroAndOne,blueBetweenZeroAndOne,opacityBetweenZeroAndOne) takes 3 or 4 numbers separated by commas \",\" as arguments. " + this.child.toString() + " is an invalid argument.");
                        }
                    };
                }

                public String getDescription() {
                    return "creates a color based on the specified red, green, and blue arguments, which range from 0 to 1. A fourth alpha, or opacity, argument is optional, also ranging from 0 to 1, and defaults to 1 (completely opaque) if not specified.";
                }

                public int getType() {
                    return 4;
                }
            });
            unaryOperators.put("integer", new UnaryOperatorCreator(){

                public UnaryOperator create(ExpressionNode child) {
                    return new UnaryOperator(child){

                        public Value evaluate() {
                            Value value = this.child.evaluate();
                            if (value instanceof DecimalValue) {
                                return new IntegerValue((int)Math.round(((DecimalValue)value).value));
                            }
                            return new ErrorValue("createErrorValue() takes a number as an argument, " + value + " is an invalid argument.");
                        }
                    };
                }

                public String getDescription() {
                    return "creates an IntegerValue with the specified number (which gets rounded if it's not an integer).";
                }

                public int getType() {
                    return 4;
                }
            });
        }
    }
}

