/*
 * Decompiled with CFR 0.152.
 */
package math3D;

import generalMathClasses.Window2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import primitives3D.Vector3D;

public class Window3D
extends Window2D {
    private double viewerZdist = 50.0;
    private double zoom = 30.0;
    public boolean drawFor3D = true;
    private Vector3D rotatedXAxis = new Vector3D(1.0, 0.0, 0.0);
    private Vector3D rotatedYAxis = new Vector3D(0.0, 1.0, 0.0);
    private Vector3D rotatedZAxis = new Vector3D(0.0, 0.0, 1.0);
    double denom = 0.0;
    Vector3D tempPoint = new Vector3D(0.0, 0.0, 0.0);

    public Window3D(int w, int h) {
        super(w, h);
    }

    public void setRotation(double xrot, double yrot, double zrot) {
        this.rotatedXAxis.x = 1.0;
        this.rotatedXAxis.y = 0.0;
        this.rotatedXAxis.z = 0.0;
        this.rotatedYAxis.x = 0.0;
        this.rotatedYAxis.y = 1.0;
        this.rotatedYAxis.z = 0.0;
        this.rotatedZAxis.x = 0.0;
        this.rotatedZAxis.y = 0.0;
        this.rotatedZAxis.z = 1.0;
        this.rotatedXAxis.rotateVectorAboutZAxis(zrot, this.rotatedXAxis);
        this.rotatedYAxis.rotateVectorAboutZAxis(zrot, this.rotatedYAxis);
        this.rotatedZAxis.rotateVectorAboutZAxis(zrot, this.rotatedZAxis);
        this.rotatedXAxis.rotateVectorAboutXAxis(xrot, this.rotatedXAxis);
        this.rotatedYAxis.rotateVectorAboutXAxis(xrot, this.rotatedYAxis);
        this.rotatedZAxis.rotateVectorAboutXAxis(xrot, this.rotatedZAxis);
        this.rotatedXAxis.rotateVectorAboutYAxis(yrot, this.rotatedXAxis);
        this.rotatedYAxis.rotateVectorAboutYAxis(yrot, this.rotatedYAxis);
        this.rotatedZAxis.rotateVectorAboutYAxis(yrot, this.rotatedZAxis);
    }

    public void getRotatedVector3D(Vector3D pointToRotate, Vector3D pointToPutResultIn) {
        if (this.drawFor3D) {
            this.rotatePoint(pointToRotate, this.rotatedXAxis, this.rotatedYAxis, this.rotatedZAxis, pointToPutResultIn);
        } else {
            pointToPutResultIn.set(pointToRotate);
        }
    }

    private void rotatePoint(Vector3D pointToRotate, Vector3D rotatedXAxis, Vector3D rotatedYAxis, Vector3D rotatedZAxis, Vector3D pointToPutResultIn) {
        pointToPutResultIn.x = pointToRotate.x * rotatedXAxis.x + pointToRotate.y * rotatedYAxis.x + pointToRotate.z * rotatedZAxis.x;
        pointToPutResultIn.y = pointToRotate.x * rotatedXAxis.y + pointToRotate.y * rotatedYAxis.y + pointToRotate.z * rotatedZAxis.y;
        pointToPutResultIn.z = pointToRotate.x * rotatedXAxis.z + pointToRotate.y * rotatedYAxis.z + pointToRotate.z * rotatedZAxis.z;
    }

    public void getPixelFromVector3D(Vector3D p, Point pointToPutResultIn) {
        if (this.drawFor3D) {
            this.getRotatedVector3D(p, this.tempPoint);
        }
        this.getPixelFromRotatedPoint3D(this.tempPoint, pointToPutResultIn);
    }

    public void getPixelFromVector3D(Vector3D p, Point2D.Float pointToPutResultIn) {
        this.getRotatedVector3D(p, this.tempPoint);
        this.getPixelFromRotatedPoint3D(this.tempPoint, pointToPutResultIn);
    }

    public void getPixelFromRotatedPoint3D(Vector3D p, Point pointToPutResultIn) {
        if (this.drawFor3D) {
            this.denom = p.z - this.viewerZdist;
            if (this.denom > 0.0 || p.z == Double.NaN || p.x == Double.NaN || p.y == Double.NaN || Double.isInfinite(p.z) || Double.isInfinite(p.x) || Double.isInfinite(p.y)) {
                pointToPutResultIn.x = Integer.MIN_VALUE;
            } else {
                pointToPutResultIn.x = this.getXpixel(this.zoom * p.x / this.denom);
                pointToPutResultIn.y = this.getYpixel(this.zoom * p.y / this.denom);
            }
        } else {
            pointToPutResultIn.x = this.getXpixel(p.x);
            pointToPutResultIn.y = this.getYpixel(p.y);
        }
    }

    public void getPixelFromRotatedPoint3D(Vector3D p, Point2D.Float pointToPutResultIn) {
        if (this.drawFor3D) {
            this.denom = p.z - this.viewerZdist;
            if (this.denom > 0.0 || p.z == Double.NaN || p.x == Double.NaN || p.y == Double.NaN || Double.isInfinite(p.z) || Double.isInfinite(p.x) || Double.isInfinite(p.y)) {
                pointToPutResultIn.x = -2.1474836E9f;
            } else {
                pointToPutResultIn.x = (float)this.getXpixelAsDouble(this.zoom * p.x / this.denom);
                pointToPutResultIn.y = (float)this.getYpixelAsDouble(this.zoom * p.y / this.denom);
            }
        } else {
            pointToPutResultIn.x = (float)this.getXpixelAsDouble(p.x);
            pointToPutResultIn.y = (float)this.getYpixelAsDouble(p.y);
        }
    }
}

