/*
 * Decompiled with CFR 0.152.
 */
package logEnabledComponents;

import expressionConsole.ExpressionConsoleModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JRadioButtonMenuItem;
import parser.Value;
import valueTypes.DecimalValue;
import variables.Variable;

public class LogEnabledJRadioButtonMenuItem
extends JRadioButtonMenuItem
implements Observer,
ActionListener {
    private static final long serialVersionUID = -8162310483610735221L;
    private static List<String> allUniqueNames = new LinkedList<String>();
    Variable thisObjectsParameterVariable;
    ExpressionConsoleModel console = ExpressionConsoleModel.getInstance();
    boolean respondToUpdates = true;
    private boolean logEventsForThisObject = true;
    private int clickCount = 0;

    public LogEnabledJRadioButtonMenuItem(String text, String uniqueName) {
        super(text);
        if (allUniqueNames.contains(uniqueName)) {
            this.console.enterErrorMessage("There already exists a button with the name " + uniqueName + "! After this, logging and replay may not work correctly.");
        } else {
            allUniqueNames.add(uniqueName);
        }
        Variable.getVariable(uniqueName).addObserver(this, "Used by a radio button (" + uniqueName + ") for logging it's clicks.");
        this.thisObjectsParameterVariable = Variable.getVariable(uniqueName);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.logEventsForThisObject) {
            this.respondToUpdates = false;
            ++this.clickCount;
            this.console.enterExpression(String.valueOf(this.thisObjectsParameterVariable.toString()) + " = " + this.clickCount);
            this.respondToUpdates = true;
        }
    }

    public void update(Observable o, Object arg) {
        if (this.respondToUpdates && arg == this.thisObjectsParameterVariable) {
            boolean invalidValue = false;
            Value currentValue = this.thisObjectsParameterVariable.evaluate();
            if (currentValue instanceof DecimalValue) {
                if (((DecimalValue)currentValue).value != 0.0) {
                    this.doClick(0);
                } else {
                    allUniqueNames.remove(this.thisObjectsParameterVariable.toString());
                    o.deleteObserver(this);
                }
            } else {
                invalidValue = true;
            }
            if (invalidValue) {
                this.respondToUpdates = false;
                this.thisObjectsParameterVariable.set(new DecimalValue(this.clickCount));
                this.respondToUpdates = true;
                this.console.enterErrorMessage(String.valueOf(this.thisObjectsParameterVariable.toString()) + " is being used by a button and has been set to an invalid value, " + currentValue + ". It has been reset to it's previous value.");
            }
        }
    }
}

