/*
 * Decompiled with CFR 0.152.
 */
package logEnabledComponents;

import expressionConsole.ExpressionConsoleModel;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import parser.ExpressionList;
import parser.ExpressionNode;
import parser.Value;
import valueTypes.DecimalValue;
import variables.Variable;

public class LogEnabledJFrame
extends JFrame
implements ComponentListener,
WindowListener,
Observer {
    private static final long serialVersionUID = 4826646701968523374L;
    public static Image defaultIconImage = null;
    private static List<String> allUniqueNames = new LinkedList<String>();
    Variable thisFramesParameterVariable;
    ExpressionConsoleModel console = ExpressionConsoleModel.getInstance();
    boolean respondToUpdates = true;
    private boolean logEventsForThisFrame = true;
    Rectangle previousBounds = new Rectangle();
    int previousExtendedState = -5;

    public LogEnabledJFrame(String uniqueName) {
        if (allUniqueNames.contains(uniqueName)) {
            this.console.enterErrorMessage("There already exists a frame with the name " + uniqueName + "! After this, logging and replay may not work correctly.");
        } else {
            allUniqueNames.add(uniqueName);
        }
        Variable.getVariable(uniqueName).addObserver(this, "Used by a frame for logging it's parameters");
        this.thisFramesParameterVariable = Variable.getVariable(uniqueName);
        this.addComponentListener(this);
        this.addWindowListener(this);
        if (defaultIconImage != null) {
            this.setIconImage(defaultIconImage);
        }
    }

    private void updateParameters() {
        Rectangle newBoundsRect;
        if (this.logEventsForThisFrame && (!this.previousBounds.equals(newBoundsRect = this.getBounds()) || this.previousExtendedState != this.getExtendedState())) {
            this.respondToUpdates = false;
            this.console.enterExpression(String.valueOf(this.thisFramesParameterVariable.toString()) + " = [" + newBoundsRect.x + ", " + newBoundsRect.y + ", " + newBoundsRect.width + ", " + newBoundsRect.height + ", " + this.getExtendedState() + "]");
            this.respondToUpdates = true;
        }
    }

    public void componentResized(ComponentEvent e) {
        this.updateParameters();
    }

    public void componentMoved(ComponentEvent e) {
        this.updateParameters();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void update(Observable o, Object arg) {
        if (this.respondToUpdates && arg == this.thisFramesParameterVariable) {
            boolean invalidValue = false;
            Value currentValue = this.thisFramesParameterVariable.evaluate();
            if (currentValue instanceof DecimalValue) {
                if (((DecimalValue)currentValue).value == 0.0) {
                    allUniqueNames.remove(this.thisFramesParameterVariable.toString());
                    o.deleteObserver(this);
                    this.dispose();
                } else {
                    invalidValue = true;
                }
            } else if (currentValue instanceof ExpressionList) {
                ExpressionNode[] allParameters = ((ExpressionList)currentValue).getNodes();
                if (allParameters.length == 5) {
                    int[] parameterValues = new int[5];
                    int i = 0;
                    while (i < parameterValues.length && !invalidValue) {
                        Value xValue = allParameters[i].evaluate();
                        if (xValue instanceof DecimalValue) {
                            parameterValues[i] = (int)((DecimalValue)xValue).value;
                        } else {
                            invalidValue = true;
                        }
                        ++i;
                    }
                    if (!invalidValue) {
                        Rectangle newBoundsRect;
                        i = 0;
                        while (i < parameterValues.length - 1) {
                            parameterValues[i] = parameterValues[i] < 1 ? 1 : parameterValues[i];
                            ++i;
                        }
                        this.previousBounds = newBoundsRect = new Rectangle(parameterValues[0], parameterValues[1], parameterValues[2], parameterValues[3]);
                        this.previousExtendedState = parameterValues[4];
                        if (!newBoundsRect.equals(this.getBounds())) {
                            this.setBounds(newBoundsRect);
                        }
                        if (this.getExtendedState() != parameterValues[4]) {
                            this.setExtendedState(parameterValues[4]);
                        }
                    }
                } else {
                    invalidValue = true;
                }
            } else {
                invalidValue = true;
            }
            if (invalidValue) {
                this.console.enterErrorMessage(String.valueOf(this.thisFramesParameterVariable.toString()) + " is being used by a frame and has been set to an invalid value, " + currentValue + ". It will be reset to the frame's current parameters.");
                this.updateParameters();
            }
        }
    }

    public void setVisible(boolean b) {
        this.logEventsForThisFrame = false;
        super.setVisible(b);
        this.logEventsForThisFrame = true;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.getDefaultCloseOperation() == 2) {
            this.console.enterExpression(String.valueOf(this.thisFramesParameterVariable.toString()) + " = 0");
        }
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
        this.updateParameters();
    }

    public void windowDeiconified(WindowEvent e) {
        this.updateParameters();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

