/*
 * Decompiled with CFR 0.152.
 */
package graphicsUtilities;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import sun.awt.geom.Crossings;

public class Polygon2D
implements Shape,
Serializable {
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle bounds;
    private static final long serialVersionUID = -6460061437900069969L;

    public Polygon2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polygon2D(float[] xpoints, float[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints];
        this.ypoints = new float[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void translate(int deltaX, int deltaY) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + (float)deltaX;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + (float)deltaY;
        }
        if (this.bounds != null) {
            this.bounds.translate(deltaX, deltaY);
        }
    }

    void calculateBounds(float[] xpoints, float[] ypoints, int npoints) {
        int boundsMinX = Integer.MAX_VALUE;
        int boundsMinY = Integer.MAX_VALUE;
        int boundsMaxX = Integer.MIN_VALUE;
        int boundsMaxY = Integer.MIN_VALUE;
        int i = 0;
        while (i < npoints) {
            double x = xpoints[i];
            boundsMinX = (int)Math.min((double)boundsMinX, x);
            boundsMaxX = (int)Math.max((double)boundsMaxX, x);
            double y = ypoints[i];
            boundsMinY = (int)Math.min((double)boundsMinY, y);
            boundsMaxY = (int)Math.max((double)boundsMaxY, y);
            ++i;
        }
        this.bounds = new Rectangle(boundsMinX, boundsMinY, boundsMaxX - boundsMinX, boundsMaxY - boundsMinY);
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    @Deprecated
    public Rectangle getBoundingBox() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Deprecated
    public boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.getBoundingBox().contains(x, y)) {
            return false;
        }
        hits = 0;
        lastx = this.xpoints[this.npoints - 1];
        lasty = this.ypoints[this.npoints - 1];
        i = 0;
        while (i < this.npoints) {
            block8: {
                block11: {
                    block12: {
                        block10: {
                            block9: {
                                curx = this.xpoints[i];
                                cury = this.ypoints[i];
                                if (cury == lasty) break block8;
                                if (!(curx < lastx)) break block9;
                                if (x >= lastx) break block8;
                                leftx = curx;
                                break block10;
                            }
                            if (x >= curx) break block8;
                            leftx = lastx;
                        }
                        if (!(cury < lasty)) break block11;
                        if (y < cury || y >= lasty) break block8;
                        if (!(x < leftx)) break block12;
                        ++hits;
                        break block8;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl35
                }
                if (y < lasty || y >= cury) break block8;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl35:
                    // 2 sources

                    if (test1 < test2 / (lasty - cury) * (lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return (hits & true) != false;
    }

    private Crossings getCrossings(double xlo, double ylo, double xhi, double yhi) {
        Crossings.EvenOdd cross = new Crossings.EvenOdd(xlo, ylo, xhi, yhi);
        double lastx = this.xpoints[this.npoints - 1];
        double lasty = this.ypoints[this.npoints - 1];
        int i = 0;
        while (i < this.npoints) {
            double curx = this.xpoints[i];
            double cury = this.ypoints[i];
            if (cross.accumulateLine(lastx, lasty, curx, cury)) {
                return null;
            }
            lastx = curx;
            lasty = cury;
            ++i;
        }
        return cross;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross == null || !cross.isEmpty();
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.getBoundingBox().intersects(x, y, w, h)) {
            return false;
        }
        Crossings cross = this.getCrossings(x, y, x + w, y + h);
        return cross != null && cross.covers(y, y + h);
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Polygon2DPathIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class Polygon2DPathIterator
    implements PathIterator {
        Polygon2D poly;
        AffineTransform transform;
        int index;

        public Polygon2DPathIterator(Polygon2D pg, AffineTransform at) {
            this.poly = pg;
            this.transform = at;
            if (pg.npoints == 0) {
                this.index = 1;
            }
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.index > this.poly.npoints;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(float[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            if (this.index >= this.poly.npoints) {
                return 4;
            }
            coords[0] = this.poly.xpoints[this.index];
            coords[1] = this.poly.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

