/*
 * Decompiled with CFR 0.152.
 */
package graphicsUtilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import javax.swing.JFrame;

public class GeneralGraphicsUtilities {
    public static void drawErrorMessage(Graphics2D g, String message, int widthOfDrawingSpace) {
        LineBreakMeasurer linebreaker = new LineBreakMeasurer(new AttributedString(message).getIterator(), g.getFontRenderContext());
        g.setColor(Color.red);
        float y = 0.0f;
        while (linebreaker.getPosition() < message.length()) {
            TextLayout tl = linebreaker.nextLayout(widthOfDrawingSpace);
            tl.draw(g, 0.0f, y += tl.getAscent());
            y += tl.getDescent() + tl.getLeading();
        }
    }

    public static void centerFrame(JFrame frame, int width, int height) {
        frame.setSize(new Dimension(width, height));
        GeneralGraphicsUtilities.centerFrame(frame);
    }

    public static void centerFrame(JFrame frame) {
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2, frameSize.width, frameSize.height);
    }
}

