/*
 * Decompiled with CFR 0.152.
 */
package expressionConsole;

import expressionConsole.ExpressionConsoleHistoryEntry;
import expressionConsole.ExpressionConsoleModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class ExpressionConsoleView
extends JScrollPane
implements Observer,
AdjustmentListener {
    private static final long serialVersionUID = 6185291782620102768L;
    ExpressionConsoleModel model = ExpressionConsoleModel.getInstance();
    StyledDocument document;
    JTextPane textPane = new JTextPane();
    int displayedHistorySize = 0;
    boolean scrollBarAdjustmentWasFromTheUser = true;

    public ExpressionConsoleView() {
        this.textPane.setEditable(false);
        this.setViewportView(this.textPane);
        this.textPane.setBackground(Color.black);
        this.textPane.setForeground(Color.orange);
        this.textPane.setFont(Font.decode("Monospaced-PLAIN-13"));
        Style style = this.textPane.addStyle("0", null);
        StyleConstants.setForeground(style, Color.orange);
        style = this.textPane.addStyle("1", null);
        StyleConstants.setForeground(style, Color.green);
        style = this.textPane.addStyle("2", null);
        StyleConstants.setForeground(style, Color.red);
        StyleConstants.setBold(style, true);
        style = this.textPane.addStyle("3", null);
        StyleConstants.setForeground(style, Color.CYAN);
        this.document = this.textPane.getStyledDocument();
        this.getVerticalScrollBar().addAdjustmentListener(this);
        this.update(null, null);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.scrollBarAdjustmentWasFromTheUser) {
            e.getAdjustable().setValue(e.getAdjustable().getMaximum());
        }
        this.scrollBarAdjustmentWasFromTheUser = true;
    }

    public void update(Observable o, Object arg) {
        List<ExpressionConsoleHistoryEntry> historyList = this.model.getExpressionHistory().getExpressionList();
        int actualHistorySize = historyList.size();
        this.scrollBarAdjustmentWasFromTheUser = false;
        try {
            int i = this.displayedHistorySize;
            while (i < actualHistorySize) {
                ExpressionConsoleHistoryEntry currentEntry = historyList.get(i);
                this.document.insertString(this.document.getLength(), String.valueOf(currentEntry.getString()) + "\n", this.textPane.getStyle(String.valueOf(currentEntry.getType())));
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.displayedHistorySize = actualHistorySize;
    }
}

