/*
 * Decompiled with CFR 0.152.
 */
package expressionConsole;

import expressionConsole.ExpressionConsoleHistory;
import expressionConsole.ExpressionConsoleHistoryEntry;
import java.util.Observable;
import parser.RecursiveDescentParser;
import parser.Value;
import valueTypes.ErrorValue;

public class ExpressionConsoleModel
extends Observable {
    private ExpressionConsoleHistory expressionHistory = new ExpressionConsoleHistory();
    private RecursiveDescentParser parser = new RecursiveDescentParser();
    static ExpressionConsoleModel INSTANCE = null;

    private ExpressionConsoleModel() {
    }

    public static ExpressionConsoleModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExpressionConsoleModel();
        }
        return INSTANCE;
    }

    public void enterExpression(String expressionString) {
        this.expressionHistory.getExpressionList().add(new ExpressionConsoleHistoryEntry(expressionString, 0));
        Value parseResult = this.parser.parse(expressionString).evaluate();
        this.expressionHistory.getExpressionList().add(new ExpressionConsoleHistoryEntry(parseResult.toString(), parseResult instanceof ErrorValue ? 2 : 1));
        this.setChanged();
        this.notifyObservers();
    }

    public void enterErrorMessage(String messageString) {
        this.expressionHistory.getExpressionList().add(new ExpressionConsoleHistoryEntry(messageString, 2));
        this.setChanged();
        this.notifyObservers();
    }

    public void enterMessage(String messageString) {
        this.expressionHistory.getExpressionList().add(new ExpressionConsoleHistoryEntry(messageString, 3));
        this.setChanged();
        this.notifyObservers();
    }

    public ExpressionConsoleHistory getExpressionHistory() {
        return this.expressionHistory;
    }

    public RecursiveDescentParser getParser() {
        return this.parser;
    }

    public void recordInitialVariableValues() {
        this.expressionHistory.recordInitialVariableValues();
    }

    public void executeFunction(String function) {
        this.parser.parse("executeFunction({" + function + "})").evaluate();
    }
}

