/*
 * Decompiled with CFR 0.152.
 */
package example;

import parser.RecursiveDescentParser;
import parser.Value;
import valueTypes.BooleanValue;
import valueTypes.DecimalValue;

public class RecursiveDescentParserTest {
    static RecursiveDescentParser parser = new RecursiveDescentParser();

    public static void main(String[] args) {
        RecursiveDescentParserTest.assertParseResultEquals("2+2", 4.0);
        RecursiveDescentParserTest.assertParseResultEquals("2+(2+(2+2))", 8.0);
        RecursiveDescentParserTest.assertParseResultEquals("2*(2+(2+2))", 12.0);
        RecursiveDescentParserTest.assertParseResultEquals("2+(2*(2+2))", 10.0);
        RecursiveDescentParserTest.assertParseResultEquals("-2", -2.0);
        RecursiveDescentParserTest.assertParseResultEquals("-(5^-2)", -Math.pow(5.0, -2.0));
        RecursiveDescentParserTest.assertParseResultEquals("5^5", Math.pow(5.0, 5.0));
        RecursiveDescentParserTest.assertParseResultEquals("5+5*5^5", 5.0 + 5.0 * Math.pow(5.0, 5.0));
        RecursiveDescentParserTest.assertParseResultEquals("5+(5*5)^5", 5.0 + Math.pow(25.0, 5.0));
        RecursiveDescentParserTest.assertParseResultEquals("(5+5)*5^5", 10.0 * Math.pow(5.0, 5.0));
        RecursiveDescentParserTest.assertParseResultEquals("5E3", 5000.0);
        RecursiveDescentParserTest.assertParseResultEquals("2+5E3", 5002.0);
        RecursiveDescentParserTest.assertParseResultEquals("sin(3)", Math.sin(3.0));
        RecursiveDescentParserTest.assertParseResultEquals("3Esin(-3+(7^3-400*(6*-3)))", 3.0 * Math.pow(10.0, Math.sin(-3.0 + (Math.pow(7.0, 3.0) - -7200.0))));
        double f = Math.pow(99.0, -2.0);
        double d = 6.0 - Math.pow(9.0, f);
        double c = 8.0 + d * 5.0;
        double b = Math.pow(6.0, c);
        double a = -b;
        RecursiveDescentParserTest.assertParseResultEquals("a = -(b = 6^(c = 8+(d = 6-9^(f=99^-2))*5))", a);
        RecursiveDescentParserTest.assertParseResultEquals("a/b", a / b);
        RecursiveDescentParserTest.assertParseResultEquals("c%d", c % d);
        RecursiveDescentParserTest.assertParseResultEquals("f%a/d*c", f % a / d * c);
        RecursiveDescentParserTest.assertParseResultEquals("cos(5)", Math.cos(5.0));
        RecursiveDescentParserTest.assertParseResultEquals("tan(5)", Math.tan(5.0));
        RecursiveDescentParserTest.assertParseResultEquals("cot(.5)", Math.tan(1.0707963267948966));
        RecursiveDescentParserTest.assertParseResultEquals("sec(.5)", 1.0 / Math.cos(0.5));
        RecursiveDescentParserTest.assertParseResultEquals("csc(.5)", 1.0 / Math.sin(0.5));
        RecursiveDescentParserTest.assertParseResultEquals("asin(0.5)", Math.asin(0.5));
        RecursiveDescentParserTest.assertParseResultEquals("acos(.5)", Math.acos(0.5));
        RecursiveDescentParserTest.assertParseResultEquals("atan(.5)", Math.atan(0.5));
        RecursiveDescentParserTest.assertParseResultEquals("ln(5)", Math.log(5.0));
        RecursiveDescentParserTest.assertParseResultEquals("log(1000)", 3.0);
        RecursiveDescentParserTest.assertParseResultEquals("abs(-5)", 5.0);
        RecursiveDescentParserTest.assertParseResultEquals("3!", 6.0);
        RecursiveDescentParserTest.assertParseResultEquals("(2+1)!+4", 10.0);
        RecursiveDescentParserTest.assertParseResultEquals("1+2-3*4/5^6E-7%8!", 3.0 - 12.0 / Math.pow(5.0, 6.0 * Math.pow(10.0, -7.0)));
        RecursiveDescentParserTest.assertParseResultEquals("sqrt(25)", 5.0);
        RecursiveDescentParserTest.assertParseResultEquals("round(6.5)", 7.0);
        RecursiveDescentParserTest.assertParseResultEquals("round(6.4)", 6.0);
        RecursiveDescentParserTest.assertParseResultEquals("floor(6.6)", 6.0);
        RecursiveDescentParserTest.assertParseResultEquals("floor(6.4)", 6.0);
        RecursiveDescentParserTest.assertParseResultEquals("ceil(6.6)", 7.0);
        RecursiveDescentParserTest.assertParseResultEquals("ceil(6.4)", 7.0);
        RecursiveDescentParserTest.assertParseResultEquals("pi", Math.PI);
        RecursiveDescentParserTest.assertParseResultEquals("e", Math.E);
        RecursiveDescentParserTest.assertParseResultEquals("Infinity", Double.POSITIVE_INFINITY);
        RecursiveDescentParserTest.assertParseResultEquals("true", true);
        RecursiveDescentParserTest.assertParseResultEquals("false", false);
        RecursiveDescentParserTest.assertParseResultEquals("1<2", true);
        RecursiveDescentParserTest.assertParseResultEquals("2<1", false);
        RecursiveDescentParserTest.assertParseResultEquals("2<2", false);
        RecursiveDescentParserTest.assertParseResultEquals("10^2-50*2<2E2", true);
        RecursiveDescentParserTest.assertParseResultEquals("1<=2", true);
        RecursiveDescentParserTest.assertParseResultEquals("2<=1", false);
        RecursiveDescentParserTest.assertParseResultEquals("2<=2", true);
        RecursiveDescentParserTest.assertParseResultEquals("1>2", false);
        RecursiveDescentParserTest.assertParseResultEquals("2>1", true);
        RecursiveDescentParserTest.assertParseResultEquals("2>2", false);
        RecursiveDescentParserTest.assertParseResultEquals("10^2-50*2>2E2", false);
        RecursiveDescentParserTest.assertParseResultEquals("1>=2", false);
        RecursiveDescentParserTest.assertParseResultEquals("2>=1", true);
        RecursiveDescentParserTest.assertParseResultEquals("2>=2", true);
        RecursiveDescentParserTest.assertParseResultEquals("2 == 2", true);
        RecursiveDescentParserTest.assertParseResultEquals("2 == 6", false);
        RecursiveDescentParserTest.assertParseResultEquals("2 != 2", false);
        RecursiveDescentParserTest.assertParseResultEquals("2 != 6", true);
        RecursiveDescentParserTest.assertParseResultEquals("true && true", true);
        RecursiveDescentParserTest.assertParseResultEquals("true && false", false);
        RecursiveDescentParserTest.assertParseResultEquals("false && true", false);
        RecursiveDescentParserTest.assertParseResultEquals("true || true", true);
        RecursiveDescentParserTest.assertParseResultEquals("true || false", true);
        RecursiveDescentParserTest.assertParseResultEquals("false || true", true);
        RecursiveDescentParserTest.assertParseResultEquals("false || false", false);
        RecursiveDescentParserTest.assertParseResultEquals("4!>=5^2-1&&2*2==2^2&&3!!=4!*2", true);
        RecursiveDescentParserTest.assertParseResultEquals("a = 3", 3.0);
        RecursiveDescentParserTest.assertParseResultEquals("b = 4", 4.0);
        RecursiveDescentParserTest.evaluate("f = createFunction(a+b)");
        RecursiveDescentParserTest.evaluate("executeFunction(f)");
        RecursiveDescentParserTest.assertParseResultEquals("b = 7", 7.0);
        RecursiveDescentParserTest.evaluate("executeFunction(f)");
        RecursiveDescentParserTest.evaluate("g = {c = (a*b)}");
        RecursiveDescentParserTest.evaluate("executeFunction(g)");
        RecursiveDescentParserTest.assertParseResultEquals("c", 21.0);
        RecursiveDescentParserTest.evaluate("f = {a = 0;b = 1; c = 2; d = false}");
        RecursiveDescentParserTest.evaluate("executeFunction(f)");
        RecursiveDescentParserTest.assertParseResultEquals("a", 0.0);
        RecursiveDescentParserTest.assertParseResultEquals("b", 1.0);
        RecursiveDescentParserTest.assertParseResultEquals("c", 2.0);
        RecursiveDescentParserTest.assertParseResultEquals("d", false);
        RecursiveDescentParserTest.evaluate("if(0<1){a = 5}");
        RecursiveDescentParserTest.assertParseResultEquals("a", 5.0);
        RecursiveDescentParserTest.assertParseResultEquals("a = 5.0", 5.0);
        RecursiveDescentParserTest.assertParseResultEquals("a", 5.0);
        RecursiveDescentParserTest.evaluate("sum = {if((a = a+1)<500){executeFunction(sum)}}");
        RecursiveDescentParserTest.evaluate("executeFunction(sum)");
        RecursiveDescentParserTest.assertParseResultEquals("a", 500.0);
        RecursiveDescentParserTest.assertParseResultEquals("true?5:4", 5.0);
        RecursiveDescentParserTest.assertParseResultEquals("4!>=5^2-1&&2*2==2^2&&3!!=4!*2?5:4", 5.0);
        RecursiveDescentParserTest.assertParseResultEquals("false?5:4", 4.0);
        RecursiveDescentParserTest.evaluate("f={d=(a=0)<1;b=1;c =4!>=5^2-1&&2*2==2^2&&3!!=4!*2?(a==0&&b==1&&d?567:568):678;d=false}");
        RecursiveDescentParserTest.evaluate("executeFunction(f)");
        RecursiveDescentParserTest.assertParseResultEquals("c", 567.0);
        RecursiveDescentParserTest.assertParseResultEquals("b = 10", 10.0);
        RecursiveDescentParserTest.evaluate("f = {while(b < 100){b = b+1}}");
        RecursiveDescentParserTest.evaluate("executeFunction(f)");
        RecursiveDescentParserTest.assertParseResultEquals("b", 100.0);
        RecursiveDescentParserTest.assertParseResultEquals("a = 1", 1.0);
        RecursiveDescentParserTest.evaluate("f = {for(i = 1;i<20;i = i+1){a = a*i}}");
        RecursiveDescentParserTest.evaluate("executeFunction(f)");
        a = 1.0;
        int i = 1;
        while (i < 20) {
            a *= (double)i;
            ++i;
        }
        RecursiveDescentParserTest.assertParseResultEquals("i", i);
        RecursiveDescentParserTest.assertParseResultEquals("a", a);
        RecursiveDescentParserTest.assertParseResultEquals("[1,2,3]", "[1.0, 2.0, 3.0]");
        RecursiveDescentParserTest.assertParseResultEquals("createErrorValue(\"test error value\")", "test error value");
    }

    private static void evaluate(String expression) {
        Value result = parser.parse(expression).evaluate();
        System.out.println("executed " + expression);
        System.out.println("  result is " + result);
    }

    private static void assertParseResultEquals(String expression, boolean b) {
        Value aVal = parser.parse(expression).evaluate();
        if (aVal instanceof BooleanValue && ((BooleanValue)aVal).value == b) {
            System.out.println("success! " + expression + " == " + b);
            return;
        }
        new Exception(aVal + " != " + b).printStackTrace();
    }

    private static void assertParseResultEquals(String expression, double b) {
        Value aVal = parser.parse(expression).evaluate();
        if (aVal instanceof DecimalValue && ((DecimalValue)aVal).value == b) {
            System.out.println("success! " + expression + " == " + b);
            return;
        }
        new Exception(aVal + " != " + b).printStackTrace();
    }

    private static void assertParseResultEquals(String expression, String result) {
        Value aVal = parser.parse(expression).evaluate();
        if (aVal.toString().equals(result)) {
            System.out.println("success! " + expression + " == " + result);
            return;
        }
        new Exception(aVal + " != " + result).printStackTrace();
    }
}

