/*
 * Decompiled with CFR 0.152.
 */
package drawing3D;

import drawing3D.MinimalObject3DViewingPanel;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class RotatableObject3DViewingPanel
extends MinimalObject3DViewingPanel
implements Runnable,
MouseInputListener {
    private static final long serialVersionUID = 6264324613452387956L;
    protected boolean animate = true;
    public boolean stopThread = false;
    protected double rotationIncrementX = 0.0;
    protected double rotationIncrementY = 0.0;
    double tempRotationIncrementX = 0.0;
    double tempRotationIncrementY = 0.0;
    protected double rotationStateX = 2.7;
    protected double rotationStateY = 1.0;
    double oldMouseX = 0.0;
    double oldMouseY = 0.0;
    protected double mouseRotationFactor = 0.006;
    long lastTimeMouseWasDragged = 0L;

    public RotatableObject3DViewingPanel() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        new Thread(this).start();
    }

    public void run() {
        while (!this.stopThread) {
            if (this.animate) {
                this.updateForEachFrame();
            }
            try {
                Thread.currentThread();
                Thread.sleep(!this.animate ? 200 : 20);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void updateForEachFrame() {
        this.rotationStateX += this.rotationIncrementX;
        if (this.rotationStateX < 0.0) {
            this.rotationStateX += Math.PI * 2;
        } else if (this.rotationStateX > Math.PI * 2) {
            this.rotationStateX -= Math.PI * 2;
        }
        this.rotationStateY += this.rotationIncrementY;
        if (this.rotationStateY < 0.0) {
            this.rotationStateY += Math.PI * 2;
        } else if (this.rotationStateY > Math.PI * 2) {
            this.rotationStateY -= Math.PI * 2;
        }
        this.viewer.window.setRotation(this.rotationStateY, 0.0, this.rotationStateX);
        this.drawObjectsOnBufferImage();
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        this.tempRotationIncrementX = (this.oldMouseX - (double)e.getX()) * this.mouseRotationFactor * (double)(this.rotationStateY < Math.PI ? -1 : 1);
        this.rotationStateX += this.tempRotationIncrementX;
        this.tempRotationIncrementY = (this.oldMouseY - (double)e.getY()) * this.mouseRotationFactor;
        this.rotationStateY += this.tempRotationIncrementY;
        this.oldMouseX = e.getX();
        this.oldMouseY = e.getY();
        this.lastTimeMouseWasDragged = System.currentTimeMillis();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.tempRotationIncrementY = 0.0;
        this.tempRotationIncrementX = 0.0;
        this.rotationIncrementY = 0.0;
        this.rotationIncrementX = 0.0;
        this.oldMouseX = e.getX();
        this.oldMouseY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
        if (System.currentTimeMillis() - this.lastTimeMouseWasDragged > 400L) {
            this.setRotationIncrementValues(0.0, 0.0);
        } else {
            this.setRotationIncrementValues(this.tempRotationIncrementX, this.tempRotationIncrementY);
        }
    }

    protected void setRotationIncrementValues(double rotationIncrementX, double rotationIncrementY) {
        this.rotationIncrementX = rotationIncrementX;
        this.rotationIncrementY = rotationIncrementY;
    }
}

