/*
 * Decompiled with CFR 0.152.
 */
package drawing3D;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import math3D.Window3D;
import primitives3D.Object3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object3DViewer {
    private Vector<Object3D> objects = new Vector();
    public Window3D window;
    private Comparator<Object3D> depthComparator = new Comparator<Object3D>(){

        @Override
        public int compare(Object3D a, Object3D b) {
            return a.centerPoint.z > b.centerPoint.z ? 1 : -1;
        }
    };
    public static Color backgroundColor = Color.black;
    static float[] colorComponents = new float[]{0.0f, 0.0f, 0.0f};
    static float[] bkgColorComponents = new float[]{0.0f, 0.0f, 0.0f};

    public Object3DViewer() {
        this(new Window3D(0, 0));
    }

    public Object3DViewer(Window3D window) {
        this.window = window;
    }

    public void add3DObject(Object3D o) {
        this.objects.add(o);
    }

    public void add3DObjects(Object3D[] objects) {
        int i = 0;
        while (i < objects.length) {
            this.add3DObject(objects[i]);
            ++i;
        }
    }

    public void add3DObjects(Collection<Object3D> objects) {
        this.objects.addAll(objects);
    }

    public void clear3DObjects() {
        this.objects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawObjectsOnThis(Graphics g) {
        Vector<Object3D> vector = this.objects;
        synchronized (vector) {
            for (Object3D currentObject : this.objects) {
                if (currentObject != null) {
                    currentObject.calculateRotation(this.window);
                    continue;
                }
                return;
            }
            Collections.sort(this.objects, this.depthComparator);
            Graphics2D g2D = (Graphics2D)g;
            Iterator<Object3D> it = this.objects.iterator();
            while (it.hasNext()) {
                it.next().drawOnThis(g2D);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawObjectsOnThis(Graphics g, ProgressMonitor progressMonitor) {
        Vector<Object3D> vector = this.objects;
        synchronized (vector) {
            progressMonitor.setProgress(1);
            progressMonitor.setNote("Calculating rotations...");
            for (Object3D currentObject : this.objects) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                if (currentObject != null) {
                    currentObject.calculateRotation(this.window);
                    continue;
                }
                return;
            }
            progressMonitor.setNote("Z-Sorting...");
            Collections.sort(this.objects, this.depthComparator);
            Graphics2D g2D = (Graphics2D)g;
            double numberOfObjects = this.objects.size();
            double currentIndex = 1.0;
            progressMonitor.setNote("Drawing objects...");
            int maxProgress = progressMonitor.getMaximum();
            Iterator<Object3D> it = this.objects.iterator();
            while (it.hasNext()) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                double d = currentIndex;
                currentIndex = d + 1.0;
                progressMonitor.setProgress((int)(d / numberOfObjects * (double)maxProgress));
                it.next().drawOnThis(g2D);
            }
        }
    }

    public static Color shadeColor(Color originalColor, double z) {
        originalColor.getColorComponents(colorComponents);
        backgroundColor.getColorComponents(bkgColorComponents);
        double percentOriginal = z / 20.0 + 0.8;
        double percentBackground = 1.0 - percentOriginal;
        int i = 0;
        while (i < 3) {
            double x = (double)colorComponents[i] * percentOriginal + (double)bkgColorComponents[i] * percentBackground;
            Object3DViewer.colorComponents[i] = (float)(x > 1.0 ? 1.0 : (x < 0.0 ? 0.0 : x));
            ++i;
        }
        return new Color(colorComponents[0], colorComponents[1], colorComponents[2]);
    }

    public Object3D getObjectWhichContainsPoint(Point point) {
        for (Object3D currentObject : this.objects) {
            if (!currentObject.contains(point)) continue;
            return currentObject;
        }
        return null;
    }
}

