/*
 * Decompiled with CFR 0.152.
 */
package curranPhysics;

import colorMap.ColorMap;
import colorMap.ColorNode;
import java.awt.Color;
import primitives3D.Ball3D;
import primitives3D.Vector3D;

public class MovingBall3D
extends Ball3D {
    public Vector3D motionVector = new Vector3D();
    private double charge = 0.0;
    public double chargePolarity = Math.random() > 0.5 ? 1 : -1;
    private Color positiveChargeColor = Color.red;
    private Color neutralChargeColor = Color.white;
    private Color negativeChargeColor = Color.blue;
    private static ColorMap map = null;

    public MovingBall3D(Vector3D p, double radius) {
        super(p, radius, Color.white);
        this.setCharge(this.chargePolarity);
    }

    public void setCharge(double charge) {
        if (this.charge != charge) {
            this.charge = charge;
            if (map == null) {
                ColorNode[] colorNodes = new ColorNode[]{new ColorNode(this.negativeChargeColor, 0.0), new ColorNode(this.neutralChargeColor, 0.5), new ColorNode(this.positiveChargeColor, 1.0)};
                map = new ColorMap(colorNodes);
            }
            this.color = map.getColorAtValue(charge / 2.0 + 0.5);
        }
    }

    public double getCharge() {
        return this.charge;
    }

    public void applyMotionVector() {
        this.p.plus(this.motionVector, this.p);
    }
}

