/*
 * Decompiled with CFR 0.152.
 */
package curranPhysics;

import curranPhysics.MovingBall3D;
import drawing3D.RotatableObject3DViewingPanel;
import java.awt.Color;
import java.awt.Dimension;
import primitives3D.Cube3DEdges;
import primitives3D.Vector3D;

public class CurranPhysics
extends RotatableObject3DViewingPanel {
    private static final long serialVersionUID = -5009278391630542659L;
    int numBalls = 60;
    double viscosity = 0.01;
    double gravity = 0.0;
    double attractiveForceStrength = 0.0;
    double repulsiveForceStrength = 0.0;
    double coulombicForceStrength = 0.0;
    MovingBall3D[] balls;
    Dimension panelSize = new Dimension();
    Vector3D tempVector = new Vector3D();
    boolean in3D = false;
    boolean allset = false;

    public CurranPhysics() {
        this.viewer.window.drawFor3D = false;
        this.createBalls();
        this.allset = true;
    }

    protected void createBalls() {
        this.viewer.clear3DObjects();
        if (this.viewer.window.drawFor3D) {
            this.viewer.add3DObjects(new Cube3DEdges(new Vector3D(0.0, 0.0, 0.0), 20.0, Color.green).getLineSegments());
        }
        this.balls = new MovingBall3D[this.numBalls];
        int i = 0;
        while (i < this.balls.length) {
            this.balls[i] = new MovingBall3D(new Vector3D(Math.random() * 20.0 - 10.0, Math.random() * 20.0 - 10.0, this.viewer.window.drawFor3D ? Math.random() * 20.0 - 10.0 : 0.0), 0.6);
            this.viewer.add3DObject(this.balls[i]);
            this.balls[i].shade = this.viewer.window.drawFor3D;
            ++i;
        }
        this.setCharges();
    }

    protected void setCharges() {
        double newValue = this.coulombicForceStrength;
        newValue = newValue < 0.0 ? -newValue : newValue;
        newValue = newValue > 1.0 ? 1.0 : newValue;
        int i = 0;
        while (i < this.balls.length) {
            this.balls[i].setCharge(newValue * this.balls[i].chargePolarity);
            ++i;
        }
    }

    protected void updateForEachFrame() {
        if (this.allset) {
            if (this.numBalls != this.balls.length) {
                this.createBalls();
            }
            if (this.in3D != this.viewer.window.drawFor3D) {
                this.viewer.window.drawFor3D = this.in3D;
                this.createBalls();
            }
            int j = 0;
            while (j < this.balls.length) {
                int i = 1 + j;
                while (i < this.balls.length) {
                    this.calculateForce(this.balls[i], this.balls[j]);
                    ++i;
                }
                ++j;
            }
            this.getSize(this.panelSize);
            int i = 0;
            while (i < this.balls.length) {
                this.bounceIfNecessary(this.balls[i]);
                this.balls[i].applyMotionVector();
                this.balls[i].motionVector.times(1.0 - this.viscosity, this.balls[i].motionVector);
                if (this.viewer.window.drawFor3D) {
                    this.balls[i].motionVector.z -= this.gravity / 1000.0;
                } else {
                    this.balls[i].motionVector.y -= this.gravity / 1000.0;
                }
                ++i;
            }
            super.updateForEachFrame();
        }
    }

    private void bounceIfNecessary(MovingBall3D ball) {
        if (ball.p.x > 10.0) {
            ball.motionVector.x = -Math.abs(ball.motionVector.x);
        } else if (ball.p.x < -10.0) {
            ball.motionVector.x = Math.abs(ball.motionVector.x);
        }
        if (ball.p.y > 10.0) {
            ball.motionVector.y = -Math.abs(ball.motionVector.y);
        } else if (ball.p.y < -10.0) {
            ball.motionVector.y = Math.abs(ball.motionVector.y);
        }
        if (ball.p.z > 10.0) {
            ball.motionVector.z = -Math.abs(ball.motionVector.z);
        } else if (ball.p.z < -10.0) {
            ball.motionVector.z = Math.abs(ball.motionVector.z);
        }
    }

    private void calculateForce(MovingBall3D ballA, MovingBall3D ballB) {
        double distance = Vector3D.calculateDistance(ballA.p, ballB.p);
        ballB.p.minus(ballA.p, this.tempVector);
        this.tempVector.times(1.0 / distance, this.tempVector);
        double dSquared = Math.pow(Math.max(distance, 0.6), 2.0);
        double force = this.attractiveForceStrength / dSquared;
        force -= this.repulsiveForceStrength / Math.pow(Math.max(distance, 0.4), 3.0);
        force -= ballA.chargePolarity * ballB.chargePolarity * this.coulombicForceStrength / dSquared;
        this.tempVector.times(force /= 1000.0, this.tempVector);
        ballA.motionVector.plus(this.tempVector, ballA.motionVector);
        ballB.motionVector.minus(this.tempVector, ballB.motionVector);
    }
}

