/*
 * Decompiled with CFR 0.152.
 */
package colorMapValue;

import colorMap.ColorMap;
import colorMap.ColorNode;
import colorMapValue.ColorMapValue;
import java.util.ArrayList;
import operators.UnaryOperator;
import operators.UnaryOperatorCreator;
import parser.ExpressionNode;
import parser.RecursiveDescentParser;
import parser.Value;
import valueTypes.CharacterSeparatedStatementPair;
import valueTypes.ColorValue;
import valueTypes.DecimalValue;
import valueTypes.ErrorValue;

public class CreateColorMapCommand
implements UnaryOperatorCreator {
    private CreateColorMapCommand() {
    }

    public static void setUpCreateColorMapCommand(RecursiveDescentParser parser) {
        parser.addUnaryOperator("createColorMap", new CreateColorMapCommand());
    }

    public UnaryOperator create(ExpressionNode child) {
        return new UnaryOperator(child){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Value evaluate() {
                ArrayList<Value> valuesFromArguments = new ArrayList<Value>();
                String commandUseExample = "createColorMap(color1, value1, color2, value2 ...)";
                if (!(this.child instanceof CharacterSeparatedStatementPair)) return new ErrorValue(String.valueOf(commandUseExample) + " takes only pairs of colors and decimal values as arguments. " + this.child.toString() + " is an invalid argument");
                CharacterSeparatedStatementPair listOfColorValuePairs = (CharacterSeparatedStatementPair)this.child;
                if (!listOfColorValuePairs.getSymbol().equals(",")) return new ErrorValue(String.valueOf(commandUseExample) + " takes only variables separated by commas as arguments. " + listOfColorValuePairs.getSymbol() + " is an invalid argument separator");
                ExpressionNode[] allColorValuePairs = ((CharacterSeparatedStatementPair)this.child).extractAllStatements();
                int i = 0;
                while (i < allColorValuePairs.length) {
                    valuesFromArguments.add(allColorValuePairs[i].evaluate());
                    ++i;
                }
                ArrayList<ColorNode> colorNodes = new ArrayList<ColorNode>();
                int i2 = 0;
                while (i2 < valuesFromArguments.size() - 1) {
                    if (!(valuesFromArguments.get(i2) instanceof ColorValue) || !(valuesFromArguments.get(i2 + 1) instanceof DecimalValue)) {
                        return new ErrorValue(String.valueOf(commandUseExample) + " takes only pairs of colors and decimal values as arguments. The arguments are not arranged in color-value pairs.");
                    }
                    colorNodes.add(new ColorNode(((ColorValue)valuesFromArguments.get((int)i2)).value, ((DecimalValue)valuesFromArguments.get((int)(i2 + 1))).value));
                    i2 += 2;
                }
                return new ColorMapValue(new ColorMap(colorNodes));
            }
        };
    }

    public int getType() {
        return 3;
    }

    public String getDescription() {
        return "takes an arbitrary number of variables as arguments and pops up a frame which has in it real time graphical editors for all of the argument variables. For example \"edit(a,b,c)\"";
    }
}

