/*
 * Decompiled with CFR 0.152.
 */
package colorMapValue;

import colorMap.ColorMap;
import colorMap.ColorNode;
import java.util.Iterator;
import parser.Value;
import valueTypes.ColorValue;

public class ColorMapValue
extends Value {
    public ColorMap value;

    public ColorMapValue(ColorMap value) {
        this.value = value;
    }

    public String getType() {
        return "color map";
    }

    public String toString() {
        return this.toParseableString();
    }

    public String toParseableString() {
        StringBuffer command = new StringBuffer();
        command.append("createColorMap(");
        Iterator<ColorNode> it = this.value.getColorNodes().iterator();
        while (it.hasNext()) {
            ColorNode currentNode = it.next();
            command.append(String.valueOf(ColorValue.generateParseableString(currentNode.color)) + "," + currentNode.value);
            command.append(it.hasNext() ? "," : "");
        }
        command.append(")");
        return command.toString();
    }

    public static ColorMap extractColorMap(Value value) {
        if (value instanceof ColorMapValue) {
            return ((ColorMapValue)value).value;
        }
        return ColorMap.generateDefaultColorMap();
    }
}

