/*
 * Decompiled with CFR 0.152.
 */
package colorMap;

import colorMap.ColorMap;
import colorMap.ColorNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ColorMapEditorPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5598720624549427817L;
    ColorMap associatedColorMap;
    List<ColorNodeEditor> nodeEditors = new ArrayList<ColorNodeEditor>();
    ColorNodeEditor grabbedNodeEditor = null;
    final ColorNodeEditorPopupMenu popupMenu = new ColorNodeEditorPopupMenu();

    public ColorMapEditorPanel(ColorMap associatedColorMap) {
        this.setColorMap(associatedColorMap);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setColorMap(ColorMap associatedColorMap) {
        this.associatedColorMap = associatedColorMap;
        this.rebuildEditorPanels();
    }

    private void rebuildEditorPanels() {
        this.nodeEditors.clear();
        Iterator<ColorNode> it = this.associatedColorMap.colorNodes.iterator();
        while (it.hasNext()) {
            this.nodeEditors.add(new ColorNodeEditor(it.next()));
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        this.associatedColorMap.paintOnThis(g, 0, 0, this.getWidth(), this.getHeight());
        Iterator<ColorNodeEditor> it = this.nodeEditors.iterator();
        while (it.hasNext()) {
            it.next().paintOnThis(g, this.getWidth(), this.getHeight());
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    private void displayColorChooserForNode(ColorNodeEditor current) {
        if (current == null) {
            return;
        }
        Color newColor = JColorChooser.showDialog(this, "Choose Color", current.node.color);
        if (newColor != null) {
            current.node.color = newColor;
            this.associatedColorMap.calculateColors();
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.grabbedNodeEditor = this.getEditorUnderPoint(e.getPoint());
    }

    private ColorNodeEditor getEditorUnderPoint(Point p) {
        for (ColorNodeEditor current : this.nodeEditors) {
            if (!current.contains(p)) continue;
            return current;
        }
        return null;
    }

    public void mouseReleased(MouseEvent e) {
        this.grabbedNodeEditor = null;
        if (e.isPopupTrigger()) {
            this.popupMenu.showForNodeEditor(this.getEditorUnderPoint(e.getPoint()), this.getWidth(), e.getComponent(), e.getX(), e.getY());
        } else {
            this.displayColorChooserForNode(this.getEditorUnderPoint(e.getPoint()));
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.grabbedNodeEditor != null) {
            double v = (double)e.getX() / (double)this.getWidth();
            this.grabbedNodeEditor.node.value = v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
            this.associatedColorMap.calculateColors();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private class ColorNodeEditor
    extends Polygon {
        ColorNode node;
        int xLowerBound;
        int xUpperBound;
        int halfEditorWidth;
        int editorHeight;
        int pointHeight;
        int offsetFromTop;

        public ColorNodeEditor(ColorNode node) {
            super(new int[5], new int[5], 5);
            this.xLowerBound = 0;
            this.xUpperBound = 0;
            this.halfEditorWidth = 4;
            this.editorHeight = 3;
            this.pointHeight = 4;
            this.offsetFromTop = 0;
            this.node = node;
        }

        public void paintOnThis(Graphics g, int width, int height) {
            this.reset();
            int thisNodesXCenter = (int)(this.node.value * (double)width);
            this.xLowerBound = thisNodesXCenter - this.halfEditorWidth;
            this.xUpperBound = thisNodesXCenter + this.halfEditorWidth;
            this.xpoints[0] = this.xLowerBound;
            this.xpoints[1] = this.xUpperBound;
            this.xpoints[2] = this.xUpperBound;
            this.xpoints[3] = thisNodesXCenter;
            this.xpoints[4] = this.xLowerBound;
            this.ypoints[0] = this.offsetFromTop;
            this.ypoints[1] = this.offsetFromTop;
            this.ypoints[2] = this.offsetFromTop + this.editorHeight;
            this.ypoints[3] = this.offsetFromTop + this.editorHeight + this.pointHeight;
            this.ypoints[4] = this.offsetFromTop + this.editorHeight;
            this.npoints = 5;
            g.setColor(this.node.color);
            g.fillPolygon(this);
            g.setColor((double)(this.node.color.getRed() + this.node.color.getGreen() + this.node.color.getBlue()) / 765.0 > 0.3 ? Color.black : Color.white);
            g.drawPolygon(this);
        }
    }

    private class ColorNodeEditorPopupMenu
    extends JPopupMenu {
        ColorNodeEditor associatedEditor = null;
        JMenuItem createNodeMenuItem;
        JMenuItem deleteNodeMenuItem = new JMenuItem("Delete Node");
        JMenuItem changeColorMenuItem;
        int currentX = 0;
        int currentWidth = 1;

        public ColorNodeEditorPopupMenu() {
            this.deleteNodeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ColorNodeEditorPopupMenu.this.associatedEditor != null) {
                        ((ColorNodeEditorPopupMenu)ColorNodeEditorPopupMenu.this).ColorMapEditorPanel.this.associatedColorMap.colorNodes.remove(ColorNodeEditorPopupMenu.this.associatedEditor.node);
                        ((ColorNodeEditorPopupMenu)ColorNodeEditorPopupMenu.this).ColorMapEditorPanel.this.associatedColorMap.calculateColors();
                        ColorMapEditorPanel.this.rebuildEditorPanels();
                    }
                }
            });
            this.changeColorMenuItem = new JMenuItem("Change Color");
            this.changeColorMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (ColorNodeEditorPopupMenu.this.associatedEditor != null) {
                        ColorMapEditorPanel.this.displayColorChooserForNode(ColorNodeEditorPopupMenu.this.associatedEditor);
                    }
                }
            });
            this.createNodeMenuItem = new JMenuItem("Create Node");
            this.createNodeMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    double value = (double)ColorNodeEditorPopupMenu.this.currentX / (double)ColorNodeEditorPopupMenu.this.currentWidth;
                    ((ColorNodeEditorPopupMenu)ColorNodeEditorPopupMenu.this).ColorMapEditorPanel.this.associatedColorMap.colorNodes.add(new ColorNode(((ColorNodeEditorPopupMenu)ColorNodeEditorPopupMenu.this).ColorMapEditorPanel.this.associatedColorMap.getColorAtValue(value), value));
                    ((ColorNodeEditorPopupMenu)ColorNodeEditorPopupMenu.this).ColorMapEditorPanel.this.associatedColorMap.calculateColors();
                    ColorMapEditorPanel.this.rebuildEditorPanels();
                }
            });
        }

        public void showForNodeEditor(ColorNodeEditor editorUnderPoint, int width, Component invoker, int x, int y) {
            this.currentX = x;
            this.currentWidth = width;
            this.associatedEditor = editorUnderPoint;
            this.removeAll();
            if (this.associatedEditor != null) {
                this.add(this.changeColorMenuItem);
                this.add(this.deleteNodeMenuItem);
            } else {
                this.add(this.createNodeMenuItem);
            }
            super.show(invoker, x, y);
        }
    }
}

