/*
 * Decompiled with CFR 0.152.
 */
package colorMap;

import colorMap.ColorNode;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorMap {
    List<ColorNode> colorNodes;
    float[] rgba_current = new float[4];
    float[] rgba_next = new float[4];
    float[] rgba_result = new float[4];
    Color[] colors = new Color[512];

    public ColorMap(ColorNode[] colorNodes) {
        this.colorNodes = new ArrayList<ColorNode>(colorNodes.length);
        int i = 0;
        while (i < colorNodes.length) {
            this.colorNodes.add(colorNodes[i]);
            ++i;
        }
        this.calculateColors();
    }

    public ColorMap(List<ColorNode> colorNodes) {
        this.colorNodes = new ArrayList<ColorNode>(colorNodes.size());
        this.colorNodes.addAll(colorNodes);
        this.calculateColors();
    }

    public void calculateColors() {
        Collections.sort(this.colorNodes);
        int i = 0;
        while (i < this.colors.length) {
            this.colors[i] = this.createColorForValue((double)i / (double)this.colors.length);
            ++i;
        }
    }

    private Color createColorForValue(double value) {
        if (this.colorNodes.size() == 1) {
            return this.colorNodes.get((int)0).color;
        }
        int i = 0;
        while (i < this.colorNodes.size() - 1) {
            ColorNode current = this.colorNodes.get(i);
            double min = current.value;
            this.rgba_current = current.color.getComponents(this.rgba_current);
            ColorNode next = this.colorNodes.get(i + 1);
            double max = next.value;
            this.rgba_next = next.color.getComponents(this.rgba_next);
            if (value >= min && value <= max) {
                int c = 0;
                while (c < this.rgba_current.length) {
                    double percentBtwMinAndMax = (value - min) / (max - min);
                    this.rgba_result[c] = (float)((1.0 - percentBtwMinAndMax) * (double)this.rgba_current[c] + percentBtwMinAndMax * (double)this.rgba_next[c]);
                    ++c;
                }
            } else {
                if (i == 0 && value < min) {
                    return current.color;
                }
                if (i == this.colorNodes.size() - 2 && value > max) {
                    return next.color;
                }
            }
            ++i;
        }
        return new Color(this.rgba_result[0], this.rgba_result[1], this.rgba_result[2], this.rgba_result[3]);
    }

    public Color getColorAtValue(double value) {
        return this.colors[(int)((value < 0.0 ? 0.0 : (value > 1.0 ? 1.0 : value)) * (double)(this.colors.length - 1))];
    }

    public Color[] getColorArray() {
        return this.colors;
    }

    public void paintOnThis(Graphics g, int x, int y, int width, int height) {
        int col = 0;
        while (col < width) {
            g.setColor(this.getColorAtValue((double)col / (double)(width - 1)));
            g.drawLine(col, y, col, y + height);
            ++col;
        }
    }

    public List<ColorNode> getColorNodes() {
        return this.colorNodes;
    }

    public static ColorMap generateDefaultColorMap() {
        ColorNode[] colorNodes = new ColorNode[]{new ColorNode(Color.blue, 0.0), new ColorNode(Color.green, 0.5), new ColorNode(Color.red, 1.0)};
        return new ColorMap(colorNodes);
    }
}

