/*
 * Decompiled with CFR 0.152.
 */
package actionScript;

import actionScript.ActionScriptFlags;
import expressionConsole.ExpressionConsoleHistory;
import expressionConsole.ExpressionConsoleHistoryEntry;
import expressionConsole.ExpressionConsoleModel;
import java.util.List;
import java.util.Map;
import parser.RecursiveDescentParser;
import variables.Variable;

public class ActionScriptPlayer {
    public static void executeScript(ExpressionConsoleHistory history) {
        if (history != null) {
            Map<String, String> initialSymbolTable = history.getInitialSymbolTableSnapshot();
            Map<String, Variable> currentSymbolTable = Variable.getSymbolTable();
            ExpressionConsoleModel console = ExpressionConsoleModel.getInstance();
            RecursiveDescentParser parser = console.getParser();
            ActionScriptFlags.suppressWarningDialogBoxes = true;
            for (Map.Entry<String, Variable> currentEntry : currentSymbolTable.entrySet()) {
                String newValue = initialSymbolTable.get(currentEntry.getKey());
                String expressionToEvaluate = String.valueOf(currentEntry.getKey()) + " = " + (newValue == null ? "0" : newValue);
                parser.parse(expressionToEvaluate).evaluate();
            }
            List<ExpressionConsoleHistoryEntry> historyList = history.getExpressionList();
            for (ExpressionConsoleHistoryEntry currentEntry : historyList) {
                if (currentEntry.getType() != 0) continue;
                console.enterExpression(currentEntry.getString());
            }
            ActionScriptFlags.suppressWarningDialogBoxes = false;
        }
    }
}

